"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateEsqlAnnotation = void 0;
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateEsqlAnnotation = exports.GenerateEsqlAnnotation = _langgraph.Annotation.Root({
  input: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => undefined
  }),
  messages: (0, _langgraph.Annotation)({
    reducer: _langgraph.messagesStateReducer,
    default: () => []
  }),
  validateEsqlResults: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => []
  }),
  maximumValidationAttempts: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => 4
  }),
  maximumEsqlGenerationAttempts: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => 4
  }),
  selectedIndexPattern: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue === undefined ? currentValue : newValue,
    default: () => undefined
  })
});