"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidateEsqlInLastMessageNode = void 0;
var _langgraph = require("@langchain/langgraph");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValidateEsqlInLastMessageNode = ({
  esClient
}) => {
  return async state => {
    const {
      messages
    } = state;
    const lastMessage = messages[messages.length - 1];
    const generatedQueries = (0, _utils.extractEsqlFromContent)(lastMessage.content);
    const validateEsqlResults = await Promise.all(generatedQueries.map(query => (0, _utils.validateEsql)(esClient, query)));
    return new _langgraph.Command({
      update: {
        maximumValidationAttempts: state.maximumValidationAttempts - 1,
        validateEsqlResults
      }
    });
  };
};
exports.getValidateEsqlInLastMessageNode = getValidateEsqlInLastMessageNode;