"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBuildErrorReportFromLastMessageNode = void 0;
var _langgraph = require("@langchain/langgraph");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBuildErrorReportFromLastMessageNode = () => {
  return async state => {
    const {
      messages,
      validateEsqlResults
    } = state;
    const lastMessage = messages[messages.length - 1];
    const containsInvalidQueries = validateEsqlResults.some(result => !result.isValid);
    if (!containsInvalidQueries) {
      throw new Error('Expected at least one invalid query to be present in the last message');
    }
    return new _langgraph.Command({
      update: {
        messages: [(0, _utils.lastMessageWithErrorReport)(lastMessage.content, validateEsqlResults)]
      }
    });
  };
};
exports.getBuildErrorReportFromLastMessageNode = getBuildErrorReportFromLastMessageNode;