"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizedEvents = getAnonymizedEvents;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _get_file_events_query = require("./get_file_events_query");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAnonymizedEvents({
  endpointIds,
  type,
  anonymizationFields,
  esClient,
  onNewReplacements,
  replacements
}) {
  const query = getQuery(type, {
    endpointIds
  });
  return getAnonymized({
    query,
    anonymizationFields,
    esClient,
    onNewReplacements,
    replacements
  });
}
function getQuery(type, options) {
  if (type === _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus) {
    const {
      endpointIds
    } = options;
    return (0, _get_file_events_query.getFileEventsQuery)({
      endpointIds
    });
  }
  throw new _errors.InvalidDefendInsightTypeError();
}
const getAnonymized = async ({
  query,
  anonymizationFields,
  esClient,
  onNewReplacements,
  replacements
}) => {
  var _result$aggregations$, _result$aggregations;
  const result = await esClient.search(query);
  const fileEvents = ((_result$aggregations$ = (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.unique_process_executable.buckets) !== null && _result$aggregations$ !== void 0 ? _result$aggregations$ : []).map(bucket => {
    const latestEvent = bucket.latest_event.hits.hits[0];
    return {
      _id: [latestEvent._id],
      'agent.id': [latestEvent._source.agent.id],
      'process.executable': [latestEvent._source.process.executable]
    };
  });

  // Accumulate replacements locally so we can, for example use the same
  // replacement for a hostname when we see it in multiple alerts:
  let localReplacements = {
    ...(replacements !== null && replacements !== void 0 ? replacements : {})
  };
  const localOnNewReplacements = newReplacements => {
    localReplacements = {
      ...localReplacements,
      ...newReplacements
    };
    onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
  };
  return fileEvents.map(fileEvent => (0, _elasticAssistantCommon.transformRawData)({
    anonymizationFields,
    currentReplacements: localReplacements,
    // <-- the latest local replacements
    getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
    onNewReplacements: localOnNewReplacements,
    // <-- the local callback
    rawData: (0, _elasticAssistantCommon.getRawDataOrDefault)(fileEvent)
  }));
};