"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNotesInFlyout = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../../../common/store");
var _store2 = require("../../../store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_STRING_ARRAY = [];
function isNoteNotNull(note) {
  return note !== null;
}
const useNotesInFlyout = args => {
  const [isNotesFlyoutVisible, setIsNotesFlyoutVisible] = (0, _react.useState)(false);
  const [eventId, setNotesEventId] = (0, _react.useState)();
  const closeNotesFlyout = (0, _react.useCallback)(() => {
    setIsNotesFlyoutVisible(false);
  }, []);
  const showNotesFlyout = (0, _react.useCallback)(() => {
    setIsNotesFlyoutVisible(true);
  }, []);
  const {
    eventIdToNoteIds,
    refetch,
    timelineId,
    activeTab
  } = args;
  const getNotesByIds = (0, _react.useMemo)(() => _store.appSelectors.notesByIdsSelector(), []);
  const notesById = (0, _use_selector.useDeepEqualSelector)(getNotesByIds);
  (0, _react.useEffect)(() => {
    if (activeTab) {
      // if activeTab changes, close the notes flyout
      closeNotesFlyout();
    }
  }, [activeTab, closeNotesFlyout]);
  const dispatch = (0, _reactRedux.useDispatch)();
  const noteIds = (0, _react.useMemo)(() => eventId && (eventIdToNoteIds === null || eventIdToNoteIds === void 0 ? void 0 : eventIdToNoteIds[eventId]) || EMPTY_STRING_ARRAY, [eventIdToNoteIds, eventId]);
  const associateNote = (0, _react.useCallback)(currentNoteId => {
    if (!eventId) return;
    dispatch(_store2.timelineActions.addNoteToEvent({
      eventId,
      id: timelineId,
      noteId: currentNoteId
    }));
    if (refetch) {
      refetch();
    }
  }, [dispatch, eventId, refetch, timelineId]);
  const notes = (0, _react.useMemo)(() => noteIds.map(currentNoteId => {
    const note = notesById[currentNoteId];
    if (note) {
      var _note$lastEdit;
      return {
        savedObjectId: note.saveObjectId,
        note: note.note,
        noteId: note.id,
        updated: ((_note$lastEdit = note.lastEdit) !== null && _note$lastEdit !== void 0 ? _note$lastEdit : note.created).getTime(),
        updatedBy: note.user
      };
    } else {
      return null;
    }
  }).filter(isNoteNotNull), [noteIds, notesById]);
  return {
    associateNote,
    notes,
    isNotesFlyoutVisible,
    closeNotesFlyout,
    showNotesFlyout,
    eventId,
    setNotesEventId
  };
};
exports.useNotesInFlyout = useNotesInFlyout;