"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineKPIs = exports.StatsContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatsContainer = exports.StatsContainer = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        font-size: ${euiTheme.font.scale.xs};
        font-weight: ${euiTheme.font.weight.semiBold};
        padding-right: ${euiTheme.size.base};

        .smallDot {
          width: 3px !important;
          display: inline-block;
        }

        .euiBadge__text {
          text-align: center;
          width: 100%;
        }
      `
  }, children);
});
StatsContainer.displayName = 'StatsContainer';
const TimelineKPIs = exports.TimelineKPIs = /*#__PURE__*/_react.default.memo(({
  kpis
}) => {
  const kpiFormat = '0,0.[000]a';
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const formattedKpis = (0, _react.useMemo)(() => {
    return {
      process: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.processCount).format(kpiFormat),
      user: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.userCount).format(kpiFormat),
      host: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.hostCount).format(kpiFormat),
      sourceIp: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.sourceIpCount).format(kpiFormat),
      destinationIp: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.destinationIpCount).format(kpiFormat)
    };
  }, [kpis]);
  const formattedKpiToolTips = (0, _react.useMemo)(() => {
    return {
      process: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.processCount).format(defaultNumberFormat),
      user: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.userCount).format(defaultNumberFormat),
      host: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.hostCount).format(defaultNumberFormat),
      sourceIp: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.sourceIpCount).format(defaultNumberFormat),
      destinationIp: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.destinationIpCount).format(defaultNumberFormat)
    };
  }, [kpis, defaultNumberFormat]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    "data-test-subj": "siem-timeline-kpis"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, null, `${i18n.PROCESS_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.process
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-process-kpi'
  }, formattedKpis.process)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, null, `${i18n.USER_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.user
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-user-kpi'
  }, formattedKpis.user)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, null, `${i18n.HOST_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.host
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-host-kpi'
  }, formattedKpis.host)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, null, `${i18n.SOURCE_IP_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.sourceIp
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-source-ip-kpi'
  }, formattedKpis.sourceIp)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, null, `${i18n.DESTINATION_IP_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.destinationIp
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-destination-ip-kpi'
  }, formattedKpis.destinationIp)))));
});
TimelineKPIs.displayName = 'TimelineKPIs';