"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TCP = exports.SOURCE = exports.SHOW_ALL_INDICATOR_MATCHES = exports.NON_EXISTENT = exports.LINK_ELASTIC_ENDPOINT_SECURITY = exports.IN = exports.FROM_ITS_ORIGINAL_PATH = exports.DESTINATION = exports.ALL_INDICATOR_MATCHES_MODAL_HEADER = exports.ALL_INDICATOR_MATCHES_MODAL_CLOSE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TCP = exports.TCP = _i18n.i18n.translate('xpack.securitySolution.timeline.tcp', {
  defaultMessage: 'TCP'
});
const DESTINATION = exports.DESTINATION = _i18n.i18n.translate('xpack.securitySolution.timeline.destination', {
  defaultMessage: 'Destination'
});
const FROM_ITS_ORIGINAL_PATH = exports.FROM_ITS_ORIGINAL_PATH = _i18n.i18n.translate('xpack.securitySolution.timeline.file.fromOriginalPathDescription', {
  defaultMessage: 'from its original path'
});
const SOURCE = exports.SOURCE = _i18n.i18n.translate('xpack.securitySolution.timeline.source', {
  defaultMessage: 'Source'
});
const IN = exports.IN = _i18n.i18n.translate('xpack.securitySolution.auditd.inDescription', {
  defaultMessage: 'in'
});
const NON_EXISTENT = exports.NON_EXISTENT = _i18n.i18n.translate('xpack.securitySolution.auditd.nonExistentDescription', {
  defaultMessage: 'an unknown process'
});
const LINK_ELASTIC_ENDPOINT_SECURITY = exports.LINK_ELASTIC_ENDPOINT_SECURITY = _i18n.i18n.translate('xpack.securitySolution.event.module.linkToElasticEndpointSecurityDescription', {
  defaultMessage: 'Open in Endpoint Security'
});
const SHOW_ALL_INDICATOR_MATCHES = count => _i18n.i18n.translate('xpack.securitySolution.event.summary.threat_indicator.showMatches', {
  values: {
    count
  },
  defaultMessage: 'Show all {count} indicator match alerts'
});
exports.SHOW_ALL_INDICATOR_MATCHES = SHOW_ALL_INDICATOR_MATCHES;
const ALL_INDICATOR_MATCHES_MODAL_HEADER = exports.ALL_INDICATOR_MATCHES_MODAL_HEADER = _i18n.i18n.translate('xpack.securitySolution.event.summary.threat_indicator.modal.allMatches', {
  defaultMessage: 'All Indicator Matches'
});
const ALL_INDICATOR_MATCHES_MODAL_CLOSE = exports.ALL_INDICATOR_MATCHES_MODAL_CLOSE = _i18n.i18n.translate('xpack.securitySolution.event.summary.threat_indicator.modal.close', {
  defaultMessage: 'Close'
});