"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRowRenderers = exports.columnRenderers = void 0;
var _generic_row_renderer = require("./auditd/generic_row_renderer");
var _empty_column_renderer = require("./empty_column_renderer");
var _netflow_row_renderer = require("./netflow/netflow_row_renderer");
var _plain_column_renderer = require("./plain_column_renderer");
var _suricata_row_renderer = require("./suricata/suricata_row_renderer");
var _unknown_column_renderer = require("./unknown_column_renderer");
var _zeek_row_renderer = require("./zeek/zeek_row_renderer");
var _generic_row_renderer2 = require("./system/generic_row_renderer");
var _threat_match_row_renderer = require("./cti/threat_match_row_renderer");
var _reason_column_renderer = require("./reason_column_renderer");
var _event_summary_column_renderer = require("./event_summary_column_renderer");
var _user_profile_renderer = require("./user_profile_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The row renderers are order dependent and will return the first renderer
// which returns true from its isInstance call. The bottom renderers which
// are netflowRenderer and plainRowRenderer are the most accepting where
// netflowRowRenderer returns true on any netflow related data set including
// Suricata and Zeek which is why Suricata and Zeek are above it. The
// plainRowRenderer always returns true to everything which is why it always
// should be last.
const defaultRowRenderers = exports.defaultRowRenderers = [_threat_match_row_renderer.threatMatchRowRenderer, ..._generic_row_renderer.auditdRowRenderers, ..._generic_row_renderer2.systemRowRenderers, _suricata_row_renderer.suricataRowRenderer, _zeek_row_renderer.zeekRowRenderer, _netflow_row_renderer.netflowRowRenderer];
const columnRenderers = exports.columnRenderers = [_reason_column_renderer.reasonColumnRenderer, _event_summary_column_renderer.eventSummaryColumnRenderer, _user_profile_renderer.userProfileColumnRenderer, _plain_column_renderer.plainColumnRenderer, _empty_column_renderer.emptyColumnRenderer, _unknown_column_renderer.unknownColumnRenderer];