"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatError = importResponse => {
  var _importResponse$error;
  const formattedErrors = ((_importResponse$error = importResponse.errors) !== null && _importResponse$error !== void 0 ? _importResponse$error : []).map(importError => {
    var _importError$error;
    return importError === null || importError === void 0 ? void 0 : (_importError$error = importError.error) === null || _importError$error === void 0 ? void 0 : _importError$error.message;
  }).filter(Boolean);
  const error = new Error(formattedErrors.join('.'));
  error.stack = undefined;
  error.name = 'Network errors';
  error.raw_network_error = importResponse;
  return error;
};
exports.formatError = formatError;