"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimelineModalBody = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _search_row = require("../search_row");
var _timelines_table = require("../timelines_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OpenTimelineModalBody = exports.OpenTimelineModalBody = /*#__PURE__*/(0, _react.memo)(({
  deleteTimelines,
  defaultPageSize,
  hideActions = [],
  isLoading,
  itemIdToExpandedNotesRowMap,
  onDeleteSelected,
  onlyFavorites,
  onOpenTimeline,
  onQueryChange,
  onSelectionChange,
  onTableChange,
  onToggleOnlyFavorites,
  onToggleShowNotes,
  pageIndex,
  pageSize,
  searchResults,
  sortDirection,
  sortField,
  timelineFilter,
  timelineType,
  templateTimelineFilter,
  title,
  totalSearchResultsCount
}) => {
  const tableRef = (0, _react.useRef)(null);
  const actionsToShow = (0, _react.useMemo)(() => {
    const actions = ['createFrom', 'duplicate'];
    if (onDeleteSelected != null && deleteTimelines != null) {
      actions.push('delete');
    }
    return actions.filter(action => !hideActions.includes(action));
  }, [onDeleteSelected, deleteTimelines, hideActions]);
  const SearchRowContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: "search-row-content"
  }, !!templateTimelineFilter && templateTimelineFilter), [templateTimelineFilter]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "open-timeline-modal-title"
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!timelineFilter && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timelineFilter, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_search_row.SearchRow, {
    "data-test-subj": "search-row",
    onlyFavorites: onlyFavorites,
    onQueryChange: onQueryChange,
    onToggleOnlyFavorites: onToggleOnlyFavorites,
    query: "",
    timelineType: timelineType
  }, SearchRowContent), /*#__PURE__*/_react.default.createElement(_timelines_table.TimelinesTable, {
    actionTimelineToShow: actionsToShow,
    "data-test-subj": "timelines-table",
    deleteTimelines: deleteTimelines,
    defaultPageSize: defaultPageSize,
    loading: isLoading,
    itemIdToExpandedNotesRowMap: itemIdToExpandedNotesRowMap,
    onOpenTimeline: onOpenTimeline,
    onSelectionChange: onSelectionChange,
    onTableChange: onTableChange,
    onToggleShowNotes: onToggleShowNotes,
    pageIndex: pageIndex,
    pageSize: pageSize,
    searchResults: searchResults,
    showExtendedColumns: false,
    sortDirection: sortDirection,
    sortField: sortField,
    timelineType: timelineType,
    totalSearchResultsCount: totalSearchResultsCount,
    tableRef: tableRef
  }))));
});
OpenTimelineModalBody.displayName = 'OpenTimelineModalBody';