"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/threat-intelligence-plugin/public");
var _reactRedux = require("react-redux");
var _user_privileges = require("../common/components/user_privileges");
var _use_set_url_params = require("../management/components/artifact_list_page/hooks/use_set_url_params");
var _blocklist_form = require("../management/pages/blocklist/view/components/blocklist_form");
var _services = require("../management/pages/blocklist/services");
var _use_investigate_in_timeline = require("./use_investigate_in_timeline");
var _store = require("../common/store");
var _kibana = require("../common/lib/kibana");
var _filters_global = require("../common/components/filters_global");
var _spy_routes = require("../common/utils/route/spy_routes");
var _use_license = require("../common/hooks/use_license");
var _types = require("../app/types");
var _containers = require("../sourcerer/containers");
var _page_wrapper = require("../common/components/page_wrapper");
var _search_bar = require("../common/components/search_bar");
var _use_global_time = require("../common/containers/use_global_time");
var _actions = require("../common/store/inputs/actions");
var _constants = require("../common/store/inputs/constants");
var _artifact_flyout = require("../management/components/artifact_list_page/components/artifact_flyout");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _timeline_capabilities = require("../common/utils/timeline_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThreatIntelligence = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    threatIntelligence,
    http,
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const ThreatIntelligencePlugin = threatIntelligence.getComponent();
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const sourcererDataView = (0, _containers.useSourcererDataView)();
  const securitySolutionStore = (0, _store.getStore)();
  const canWriteBlocklist = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canWriteBlocklist;
  const securitySolutionContext = (0, _react.useMemo)(() => ({
    securitySolutionStore,
    getFiltersGlobalComponent: () => _filters_global.FiltersGlobal,
    getPageWrapper: () => _page_wrapper.SecuritySolutionPageWrapper,
    licenseService: _use_license.licenseService,
    sourcererDataView: sourcererDataView,
    getUseInvestigateInTimeline: _use_investigate_in_timeline.useInvestigateInTimeline,
    hasAccessToTimeline,
    blockList: {
      canWriteBlocklist,
      exceptionListApiClient: _services.BlocklistsApiClient.getInstance(http),
      useSetUrlParams: _use_set_url_params.useSetUrlParams,
      // @ts-ignore
      getFlyoutComponent: () => _artifact_flyout.ArtifactFlyout,
      // @ts-ignore
      getFormComponent: () => _blocklist_form.BlockListForm
    },
    useQuery: () => (0, _reactRedux.useSelector)(_store.inputsSelectors.globalQuerySelector()),
    useFilters: () => (0, _reactRedux.useSelector)(_store.inputsSelectors.globalFiltersQuerySelector()),
    useGlobalTime: _use_global_time.useGlobalTime,
    registerQuery: query => securitySolutionStore.dispatch((0, _actions.setQuery)({
      inputId: _constants.InputsModelId.global,
      id: query.id,
      refetch: query.refetch,
      inspect: null,
      loading: query.loading
    })),
    deregisterQuery: query => securitySolutionStore.dispatch((0, _actions.deleteOneQuery)({
      inputId: _constants.InputsModelId.global,
      id: query.id
    })),
    SiemSearchBar: _search_bar.SiemSearchBar
  }), [canWriteBlocklist, http, securitySolutionStore, sourcererDataView, hasAccessToTimeline]);
  return /*#__PURE__*/_react.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
    pageName: _types.SecurityPageName.threatIntelligence
  }, /*#__PURE__*/_react.default.createElement(ThreatIntelligencePlugin, {
    securitySolutionContext: securitySolutionContext
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.threatIntelligence
  }));
});
ThreatIntelligence.displayName = 'ThreatIntelligence';
const routes = exports.routes = [{
  path: _public.THREAT_INTELLIGENCE_BASE_PATH,
  render: () => /*#__PURE__*/_react.default.createElement(ThreatIntelligence, null)
}];