"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _reprocess_failed_rules = require("./reprocess_failed_rules");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Collection of buttons to perform bulk actions on migration rules within the SIEM Rules Migrations table.
 */
const BulkActions = exports.BulkActions = /*#__PURE__*/_react.default.memo(({
  isTableLoading,
  numberOfFailedRules,
  numberOfTranslatedRules,
  numberOfSelectedRules,
  installTranslatedRule,
  installSelectedRule,
  reprocessFailedRules
}) => {
  const disableInstallTranslatedRulesButton = isTableLoading || !numberOfTranslatedRules;
  const showInstallSelectedRulesButton = numberOfSelectedRules > 0;
  const showRetryFailedRulesButton = numberOfFailedRules > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, showInstallSelectedRulesButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    color: 'primary',
    onClick: () => installSelectedRule === null || installSelectedRule === void 0 ? void 0 : installSelectedRule(),
    disabled: isTableLoading,
    isLoading: isTableLoading,
    "data-test-subj": "installSelectedRulesButton",
    "aria-label": i18n.INSTALL_SELECTED_ARIA_LABEL
  }, i18n.INSTALL_SELECTED_RULES(numberOfSelectedRules))), showRetryFailedRulesButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_reprocess_failed_rules.ReprocessFailedRulesButton, {
    onClick: () => reprocessFailedRules === null || reprocessFailedRules === void 0 ? void 0 : reprocessFailedRules(),
    isDisabled: isTableLoading,
    isLoading: isTableLoading,
    numberOfFailedRules: numberOfFailedRules
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    onClick: () => installTranslatedRule === null || installTranslatedRule === void 0 ? void 0 : installTranslatedRule(),
    disabled: disableInstallTranslatedRulesButton,
    isLoading: isTableLoading,
    "data-test-subj": "installTranslatedRulesButton",
    "aria-label": i18n.INSTALL_TRANSLATED_ARIA_LABEL
  }, numberOfTranslatedRules > 0 ? i18n.INSTALL_TRANSLATED_RULES(numberOfTranslatedRules) : i18n.INSTALL_TRANSLATED_RULES_EMPTY_STATE)));
});
BulkActions.displayName = 'BulkActions';