"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAB_HEADER_TITLE = exports.NAME_REQUIRED_ERROR_MESSAGE = exports.NAME_LABEL = exports.INSTALLED_LABEL = exports.CALLOUT_TRANSLATED_RULE_TITLE = exports.CALLOUT_TRANSLATED_RULE_INFO_TITLE = exports.CALLOUT_TRANSLATED_RULE_INFO_DESCRIPTION = exports.CALLOUT_PARTIALLY_TRANSLATED_RULE_TITLE = exports.CALLOUT_PARTIALLY_TRANSLATED_RULE_DESCRIPTION = exports.CALLOUT_NOT_TRANSLATED_RULE_TITLE = exports.CALLOUT_NOT_TRANSLATED_RULE_DESCRIPTION = exports.CALLOUT_MAPPED_TRANSLATED_RULE_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAB_HEADER_TITLE = exports.TAB_HEADER_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.title', {
  defaultMessage: 'Translation'
});
const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.nameLabel', {
  defaultMessage: 'Name'
});
const NAME_REQUIRED_ERROR_MESSAGE = exports.NAME_REQUIRED_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.nameFieldRequiredError', {
  defaultMessage: 'A name is required.'
});
const INSTALLED_LABEL = exports.INSTALLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.installedLabel', {
  defaultMessage: 'Installed'
});
const CALLOUT_TRANSLATED_RULE_TITLE = exports.CALLOUT_TRANSLATED_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.translatedRuleCalloutTitle', {
  defaultMessage: 'This rule has been fully translated. Install rule to finish migration. Once installed, you’ll be able to fine tune the rule.'
});
const CALLOUT_MAPPED_TRANSLATED_RULE_TITLE = exports.CALLOUT_MAPPED_TRANSLATED_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.mappedTranslatedRuleCalloutTitle', {
  defaultMessage: 'This rule was mapped to an Elastic authored rule. Click Install & enable rule to complete migration. You can fine-tune it later.'
});
const CALLOUT_PARTIALLY_TRANSLATED_RULE_TITLE = exports.CALLOUT_PARTIALLY_TRANSLATED_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.partiallyTranslatedRuleCalloutTitle', {
  defaultMessage: 'Part of the query could not be translated.'
});
const CALLOUT_PARTIALLY_TRANSLATED_RULE_DESCRIPTION = exports.CALLOUT_PARTIALLY_TRANSLATED_RULE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.partiallyTranslatedRuleCalloutDescription', {
  defaultMessage: 'To save this rule, finish writing the query. If you need help, please contact Elastic support.'
});
const CALLOUT_NOT_TRANSLATED_RULE_TITLE = exports.CALLOUT_NOT_TRANSLATED_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.notTranslatedRuleCalloutTitle', {
  defaultMessage: 'This query couldn’t be translated.'
});
const CALLOUT_NOT_TRANSLATED_RULE_DESCRIPTION = exports.CALLOUT_NOT_TRANSLATED_RULE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.notTranslatedRuleCalloutDescription', {
  defaultMessage: 'This might be caused by feature differences between SIEM products. If possible, update the rule manually.'
});
const CALLOUT_TRANSLATED_RULE_INFO_TITLE = exports.CALLOUT_TRANSLATED_RULE_INFO_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.partiallyTranslatedRuleCalloutTitle', {
  defaultMessage: 'Translation successful. Install the rule to customize it.'
});
const CALLOUT_TRANSLATED_RULE_INFO_DESCRIPTION = exports.CALLOUT_TRANSLATED_RULE_INFO_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationDetails.translationTab.partiallyTranslatedRuleCalloutDescription', {
  defaultMessage: 'After you install the rule, you can modify or update it with full access to all features.'
});