"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TranslationTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _translation_results = require("../../../../utils/translation_results");
var _callout = require("./callout");
var _query_details = require("./query_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TranslationTab = exports.TranslationTab = /*#__PURE__*/_react.default.memo(({
  migrationRule,
  matchedPrebuiltRule,
  onTranslationUpdate
}) => {
  var _migrationRule$elasti, _migrationRule$elasti2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isInstalled = !!((_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.id);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), migrationRule.translation_result && !isInstalled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_callout.TranslationCallOut, {
    migrationRule: migrationRule
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.translationDetails.translationTab.statusTitle",
    defaultMessage: "Translation status"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "translationResultBadge",
    color: (0, _translation_results.convertTranslationResultIntoColor)(migrationRule.translation_result)
  }, isInstalled ? i18n.INSTALLED_LABEL : (0, _translation_results.convertTranslationResultIntoText)(migrationRule.translation_result))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_query_details.OriginalRuleQuery, {
    migrationRule: migrationRule
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    css: (0, _css.css)`
                    align-self: stretch;
                    border-right: ${euiTheme.border.thin};
                  `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_query_details.TranslatedRuleQuery, {
    migrationRule: migrationRule,
    matchedPrebuiltRule: matchedPrebuiltRule,
    onTranslationUpdate: onTranslationUpdate
  })))))), migrationRule.translation_result === _constants.RuleTranslationResult.FULL && !((_migrationRule$elasti2 = migrationRule.elastic_rule) !== null && _migrationRule$elasti2 !== void 0 && _migrationRule$elasti2.id) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: 'primary',
    title: i18n.CALLOUT_TRANSLATED_RULE_INFO_TITLE,
    iconType: 'info',
    size: 's'
  }, i18n.CALLOUT_TRANSLATED_RULE_INFO_DESCRIPTION)));
});
TranslationTab.displayName = 'TranslationTab';