"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsUploadMissingPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _use_kibana = require("../../../../common/lib/kibana/use_kibana");
var _panel_text = require("../../../../common/components/panel_text");
var _use_get_missing_resources = require("../../service/hooks/use_get_missing_resources");
var i18n = _interopRequireWildcard(require("./translations"));
var _context = require("../data_input_flyout/context");
var _use_get_migration_translation_stats = require("../../logic/use_get_migration_translation_stats");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleMigrationsUploadMissingPanel = exports.RuleMigrationsUploadMissingPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  topSpacerSize
}) => {
  const [missingResources, setMissingResources] = (0, _react.useState)([]);
  const {
    getMissingResources,
    isLoading
  } = (0, _use_get_missing_resources.useGetMissingResources)(setMissingResources);
  (0, _react.useEffect)(() => {
    getMissingResources(migrationStats.id);
  }, [getMissingResources, migrationStats.id]);
  if (isLoading || missingResources.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(RuleMigrationsUploadMissingPanelContent, {
    migrationStats: migrationStats,
    topSpacerSize: topSpacerSize,
    missingResources: missingResources
  });
});
RuleMigrationsUploadMissingPanel.displayName = 'RuleMigrationsUploadMissingPanel';
const RuleMigrationsUploadMissingPanelContent = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  topSpacerSize,
  missingResources
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    telemetry
  } = (0, _use_kibana.useKibana)().services.siemMigrations.rules;
  const {
    openFlyout
  } = (0, _context.useRuleMigrationDataInputContext)();
  const {
    data: translationStats,
    isLoading: isLoadingTranslationStats
  } = (0, _use_get_migration_translation_stats.useGetMigrationTranslationStats)(migrationStats.id);
  const onOpenFlyout = (0, _react.useCallback)(() => {
    openFlyout(migrationStats);
    telemetry.reportSetupMigrationOpenResources({
      migrationId: migrationStats.id,
      missingResourcesCount: missingResources.length
    });
  }, [migrationStats, openFlyout, missingResources, telemetry]);
  const totalRulesToRetry = (0, _react.useMemo)(() => {
    var _translationStats$rul, _translationStats$rul2, _translationStats$rul3;
    return ((_translationStats$rul = translationStats === null || translationStats === void 0 ? void 0 : translationStats.rules.failed) !== null && _translationStats$rul !== void 0 ? _translationStats$rul : 0) + ((_translationStats$rul2 = translationStats === null || translationStats === void 0 ? void 0 : translationStats.rules.success.result.partial) !== null && _translationStats$rul2 !== void 0 ? _translationStats$rul2 : 0) + ((_translationStats$rul3 = translationStats === null || translationStats === void 0 ? void 0 : translationStats.rules.success.result.untranslatable) !== null && _translationStats$rul3 !== void 0 ? _translationStats$rul3 : 0);
  }, [translationStats]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, topSpacerSize && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: topSpacerSize
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    style: {
      backgroundColor: euiTheme.colors.backgroundBasePrimary
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    semiBold: true
  }, i18n.RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoadingTranslationStats ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    subdued: true
  }, i18n.RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION(totalRulesToRetry))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: onOpenFlyout,
    iconType: "download",
    iconSide: "right",
    size: "s"
  }, i18n.RULE_MIGRATION_UPLOAD_BUTTON)))));
});
RuleMigrationsUploadMissingPanelContent.displayName = 'RuleMigrationsUploadMissingPanelContent';