"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingLookupsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scrollPanelCss = (0, _css.css)`
  max-height: 200px;
  overflow-y: auto;
`;
const MissingLookupsList = exports.MissingLookupsList = /*#__PURE__*/_react.default.memo(({
  missingLookups,
  uploadedLookups,
  omitLookup,
  onCopied
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.dataInputFlyout.lookups.copyExportQuery.description",
    defaultMessage: "Log in to your Splunk admin account, go to the {app}, download the following lookups individually and upload them below. You can also omit lookups that are empty or not needed, and they will be ignored in the translation.",
    values: {
      app: /*#__PURE__*/_react.default.createElement("b", null, i18n.LOOKUPS_SPLUNK_APP)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    className: scrollPanelCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, missingLookups.map(lookupName => {
    const isOmitted = uploadedLookups[lookupName] === '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: lookupName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, uploadedLookups[lookupName] != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: euiTheme.colors.success
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      style: isOmitted ? {
        textDecoration: 'line-through'
      } : {}
    }, lookupName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: lookupName
    }, copy => /*#__PURE__*/_react.default.createElement(CopyLookupNameButton, {
      lookupName: lookupName,
      onCopied: onCopied,
      copy: copy
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(OmitLookupButton, {
      lookupName: lookupName,
      omitLookup: omitLookup,
      isDisabled: isOmitted
    }))));
  })))));
});
MissingLookupsList.displayName = 'MissingLookupsList';
const CopyLookupNameButton = /*#__PURE__*/_react.default.memo(({
  lookupName,
  onCopied,
  copy
}) => {
  const onClick = (0, _react.useCallback)(() => {
    copy();
    onCopied();
  }, [copy, onCopied]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.COPY_LOOKUP_NAME_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onClick,
    iconType: "copy",
    color: "text",
    "aria-label": `${i18n.COPY_LOOKUP_NAME_TOOLTIP} ${lookupName}`,
    "data-test-subj": "lookupNameCopy"
  }));
});
CopyLookupNameButton.displayName = 'CopyLookupNameButton';
const OmitLookupButton = /*#__PURE__*/_react.default.memo(({
  lookupName,
  omitLookup,
  isDisabled: isDisabledDefault
}) => {
  const [isDisabled, setIsDisabled] = (0, _react.useState)(isDisabledDefault);
  const onClick = (0, _react.useCallback)(() => {
    setIsDisabled(true);
    omitLookup(lookupName);
  }, [omitLookup, lookupName]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onClick,
    iconType: "cross",
    color: "text",
    "aria-label": i18n.CLEAR_EMPTY_LOOKUP_TOOLTIP,
    "data-test-subj": "lookupNameClear",
    isDisabled: isDisabled
  }), [onClick, isDisabled]);
  if (isDisabled) {
    return button;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.CLEAR_EMPTY_LOOKUP_TOOLTIP
  }, button);
});
OmitLookupButton.displayName = 'OmitLookupButton';