"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_TITLE = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_PROMPT = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_NOT_UPLOADED_TITLE = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_NOT_UPLOADED = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOOKUPS_DATA_INPUT_FILE_UPLOAD_TITLE = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.lookups.lookupsFileUpload.title', {
  defaultMessage: 'Update your lookups export'
});
const LOOKUPS_DATA_INPUT_FILE_UPLOAD_PROMPT = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_PROMPT = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.lookups.lookupsFileUpload.prompt', {
  defaultMessage: 'Select or drag and drop the exported lookup files'
});
const LOOKUPS_DATA_INPUT_FILE_UPLOAD_NOT_UPLOADED_TITLE = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_NOT_UPLOADED_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.lookups.lookupsFileUpload.notUploadedTitle', {
  defaultMessage: 'Lookups not uploaded'
});
const LOOKUPS_DATA_INPUT_FILE_UPLOAD_NOT_UPLOADED = lookupsNames => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.lookups.lookupsFileUpload.notUploaded', {
  defaultMessage: 'The following files did not match any missing lookup: {lookupsNames}',
  values: {
    lookupsNames
  }
});
exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_NOT_UPLOADED = LOOKUPS_DATA_INPUT_FILE_UPLOAD_NOT_UPLOADED;
const LOOKUPS_DATA_INPUT_FILE_UPLOAD_BUTTON = exports.LOOKUPS_DATA_INPUT_FILE_UPLOAD_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.lookups.lookupsFileUpload.button', {
  defaultMessage: 'Upload'
});