"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeLegend = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_colors = require("../use_colors");
var _styles = require("../panels/styles");
var _cube_for_process = require("../panels/cube_for_process");
var _generated_text = require("../generated_text");
var _styles2 = require("./styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This component defines the cube legend that allows users to identify the meaning of the cubes
// Should be updated to be dynamic if and when non process based resolvers are possible
const NodeLegend = ({
  id,
  closePopover,
  setActivePopover,
  isOpen
}) => {
  const setAsActivePopover = (0, _react.useCallback)(() => setActivePopover('nodeLegend'), [setActivePopover]);
  const colorMap = (0, _use_colors.useColors)();
  const nodeLegendButtonTitle = _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.nodeLegendButtonTitle', {
    defaultMessage: 'Node Legend'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiButtonIcon, {
      "data-test-subj": "resolver:graph-controls:node-legend-button",
      size: "m",
      title: nodeLegendButtonTitle,
      "aria-label": nodeLegendButtonTitle,
      onClick: setAsActivePopover,
      iconType: "node",
      $backgroundColor: colorMap.graphControlsBackground,
      $iconColor: colorMap.graphControls,
      $borderColor: colorMap.graphControlsBorderColor
    }),
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    style: {
      textTransform: 'uppercase'
    }
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.nodeLegend', {
    defaultMessage: 'legend'
  })), /*#__PURE__*/_react.default.createElement("div", {
    // Limit the width based on UX design
    style: {
      maxWidth: '212px'
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledDescriptionList, {
    "data-test-subj": "resolver:graph-controls:node-legend",
    type: "column",
    columnWidths: _styles2.COLUMN_WIDTH,
    align: "left",
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListTitle, {
    "data-test-subj": "resolver:graph-controls:node-legend:title"
  }, /*#__PURE__*/_react.default.createElement(_cube_for_process.CubeForProcess, {
    id: id,
    size: "2.5em",
    "data-test-subj": "resolver:node-detail:title-icon",
    state: "running"
  })), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListDescription, {
    "data-test-subj": "resolver:graph-controls:node-legend:description"
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, null, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.runningProcessCube', {
    defaultMessage: 'Running Process'
  }))), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListTitle, {
    "data-test-subj": "resolver:graph-controls:node-legend:title"
  }, /*#__PURE__*/_react.default.createElement(_cube_for_process.CubeForProcess, {
    id: id,
    size: "2.5em",
    "data-test-subj": "resolver:node-detail:title-icon",
    state: "terminated"
  })), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListDescription, {
    "data-test-subj": "resolver:graph-controls:node-legend:description"
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, null, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.terminatedProcessCube', {
    defaultMessage: 'Terminated Process'
  }))), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListTitle, {
    "data-test-subj": "resolver:graph-controls:node-legend:title"
  }, /*#__PURE__*/_react.default.createElement(_cube_for_process.CubeForProcess, {
    id: id,
    size: "2.5em",
    "data-test-subj": "resolver:node-detail:title-icon",
    state: "loading"
  })), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListDescription, {
    "data-test-subj": "resolver:graph-controls:node-legend:description"
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, null, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.currentlyLoadingCube', {
    defaultMessage: 'Loading Process'
  }))), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListTitle, {
    "data-test-subj": "resolver:graph-controls:node-legend:title"
  }, /*#__PURE__*/_react.default.createElement(_cube_for_process.CubeForProcess, {
    id: id,
    size: "2.5em",
    "data-test-subj": "resolver:node-detail:title-icon",
    state: "error"
  })), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListDescription, {
    "data-test-subj": "resolver:graph-controls:node-legend:description"
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, null, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.errorCube', {
    defaultMessage: 'Error Process'
  })))))));
};
exports.NodeLegend = NodeLegend;