"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../common/constants");
var _overview = require("./pages/overview");
var _data_quality = require("./pages/data_quality");
var _detection_response = require("./pages/detection_response");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _entity_analytics_dashboard = require("../entity_analytics/pages/entity_analytics_dashboard");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_overview.StatefulOverview, null));
const DetectionResponseRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_detection_response.DetectionResponse, null));
const EntityAnalyticsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_entity_analytics_dashboard.EntityAnalyticsPage, null));
const DataQualityRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_data_quality.DataQuality, null));
const routes = exports.routes = [{
  path: _constants.OVERVIEW_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(OverviewRoutes, _constants.SecurityPageName.overview)
}, {
  path: _constants.DETECTION_RESPONSE_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(DetectionResponseRoutes, _constants.SecurityPageName.detectionAndResponse)
}, {
  path: _constants.ENTITY_ANALYTICS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsRoutes, _constants.SecurityPageName.entityAnalytics)
}, {
  path: _constants.DATA_QUALITY_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(DataQualityRoutes, _constants.SecurityPageName.dataQuality)
}];