"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyEmptyState = exports.HostsEmptyState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _user_privileges = require("../../common/components/user_privileges");
var _security_administration_onboarding = _interopRequireDefault(require("../images/security_administration_onboarding.svg"));
var _kibana = require("../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEXT_ALIGN_CENTER = Object.freeze({
  textAlign: 'center'
});
const MAX_SIZE_ONBOARDING_LOGO = Object.freeze({
  maxWidth: 550,
  maxHeight: 420
});
const MissingFleetAccessInfo = /*#__PURE__*/_react.default.memo(() => {
  const {
    services
  } = (0, _kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "noFleetAccess"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.onboarding.enableFleetAccess",
    defaultMessage: "Deploying Agents for the first time requires Fleet access. For more information, "
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: `${services.docLinks.links.securitySolution.privileges}`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.onboarding.onboardingDocsLink",
    defaultMessage: "view the Elastic Security documentation"
  })));
});
MissingFleetAccessInfo.displayName = 'MissingFleetAccessInfo';
const PolicyEmptyState = exports.PolicyEmptyState = /*#__PURE__*/_react.default.memo(({
  loading,
  onActionClick,
  actionDisabled,
  policyEntryPoint = false
}) => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  const {
    canAccessFleet,
    canWriteIntegrationPolicies,
    loading: authzLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "emptyPolicyTable"
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    className: "essentialAnimation"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "policyOnboardingInstructions",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingTitle",
    defaultMessage: "Get started with Elastic Defend"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionOne",
    defaultMessage: "Protect your hosts with threat prevention, detection, and deep security data visibility."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, policyEntryPoint ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionTwo.fromPolicyPage",
    defaultMessage: "From this page, you can view and manage the Elastic Defend integration policies in your environment running Elastic Defend."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionTwo.fromEndpointPage",
    defaultMessage: "From this page, you can view and manage the hosts in your environment running Elastic Defend."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionThree",
    defaultMessage: "To get started, add the Elastic Defend integration to your Agents. For more information, "
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: `${docLinks.links.siem.guide}`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingDocsLink",
    defaultMessage: "view the Elastic Security documentation"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), authzLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1
  }), !authzLoading && canAccessFleet && canWriteIntegrationPolicies && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: onActionClick,
    isDisabled: actionDisabled,
    "data-test-subj": "onboardingStartButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.actionButtonText",
    defaultMessage: "Add Elastic Defend"
  }))))), !authzLoading && !(canAccessFleet && canWriteIntegrationPolicies) && /*#__PURE__*/_react.default.createElement(MissingFleetAccessInfo, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _security_administration_onboarding.default,
    size: "original",
    style: MAX_SIZE_ONBOARDING_LOGO
  }))));
});
const EndpointsEmptyState = exports.HostsEmptyState = /*#__PURE__*/_react.default.memo(({
  loading,
  onActionClick,
  actionDisabled,
  handleSelectableOnChange,
  selectionOptions,
  policyItems
}) => {
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const policyItemsWithoutAgentPolicy = (0, _react.useMemo)(() => policyItems.filter(policy => !policy.policy_ids.length), [policyItems]);
  const policiesNotAddedToAgentPolicyCallout = (0, _react.useMemo)(() => !!policyItemsWithoutAgentPolicy.length && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "info",
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.notAddedIntegrations.title', {
      defaultMessage: 'Integrations not added to an Agent policy'
    }),
    "data-test-subj": "integrationsNotAddedToAgentPolicyCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.list.notAddedIntegrations.description",
    defaultMessage: "The following Elastic Defend integrations aren't added to an Agent policy, so they can't be deployed to an Agent. Click on an integration to edit it, and add it to an Agent policy:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", null, policyItemsWithoutAgentPolicy.map(policyItem => /*#__PURE__*/_react.default.createElement("li", {
    key: policyItem.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: getAppUrl({
      appId: _common.INTEGRATIONS_PLUGIN_ID,
      path: _public.pagePathGetters.integration_policy_edit({
        packagePolicyId: policyItem.id
      })[1]
    }),
    "data-test-subj": "integrationWithoutAgentPolicyListItem"
  }, policyItem.name)))), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.list.notAddedIntegrations.visitIntegrations",
    defaultMessage: "You can also view a list of all {integrationPolicies}.",
    values: {
      integrationPolicies: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: getAppUrl({
          appId: _common.INTEGRATIONS_PLUGIN_ID,
          path: _public.pagePathGetters.integration_details_policies({
            pkgkey: 'endpoint'
          })[1]
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.list.notAddedIntegrations.integrationPolicies",
        defaultMessage: "Elastic Defend integration policies"
      }))
    }
  })))), [getAppUrl, policyItemsWithoutAgentPolicy]);
  const policySteps = (0, _react.useMemo)(() => [{
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.stepOneTitle', {
      defaultMessage: 'Select the integration you want to use'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "m",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.stepOne",
      defaultMessage: "Select from existing integrations. This can be changed later."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
      options: selectionOptions,
      singleSelection: "always",
      isLoading: loading,
      listProps: {
        bordered: true,
        singleSelection: true
      },
      onChange: handleSelectableOnChange,
      "data-test-subj": "onboardingPolicySelect"
    }, list => {
      if (loading) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.list.loadingPolicies",
          defaultMessage: "Loading integrations"
        }));
      }
      if (!selectionOptions.length) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          color: "warning",
          "data-test-subj": "noIntegrationsAddedToAgentPoliciesCallout"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.list.noPoliciesAssignedToAgentPolicies",
          defaultMessage: "There are no Elastic Defend integrations added to Agent policies. To deploy Elastic Defend, add it to an Agent policy."
        }));
      }
      return list;
    }), policiesNotAddedToAgentPolicyCallout)
  }, {
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.stepTwoTitle', {
      defaultMessage: 'Enroll your agents enabled with Elastic Defend through Fleet'
    }),
    status: actionDisabled ? 'disabled' : '',
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "m",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.stepTwo",
      defaultMessage: "You'll be provided with the necessary commands to get started."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: onActionClick,
      isDisabled: actionDisabled,
      "data-test-subj": "onboardingStartButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyList.emptyCreateNewButton",
      defaultMessage: "Enroll Agent"
    }))))
  }], [selectionOptions, loading, handleSelectableOnChange, policiesNotAddedToAgentPolicyCallout, actionDisabled, onActionClick]);
  return /*#__PURE__*/_react.default.createElement(ManagementEmptyState, {
    loading: loading,
    dataTestSubj: "emptyHostsTable",
    steps: policySteps,
    headerComponent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.noEndpointsPrompt",
      defaultMessage: "Next step: Enroll an Agent with Elastic Defend"
    }),
    bodyComponent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.noEndpointsInstructions",
      defaultMessage: "You've added the Elastic Defend integration. Now enroll your agents using the steps below."
    })
  });
});
const ManagementEmptyState = /*#__PURE__*/_react.default.memo(({
  loading,
  dataTestSubj,
  steps,
  headerComponent,
  bodyComponent
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    className: "essentialAnimation",
    "data-test-subj": "management-empty-state-loading-spinner"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    style: TEXT_ALIGN_CENTER
  }, headerComponent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    color: "subdued",
    size: "m"
  }, bodyComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), steps && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    "data-test-subj": 'onboardingSteps'
  })))));
});
PolicyEmptyState.displayName = 'PolicyEmptyState';
EndpointsEmptyState.displayName = 'HostsEmptyState';
ManagementEmptyState.displayName = 'ManagementEmptyState';