"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionLogDateRangePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _common2 = require("@kbn/data-plugin/common");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatePickerWrapper = _common.euiStyled.div`
  padding-bottom: ${props => `${props.theme.eui.euiSizeL}`};
`;
const ActionLogDateRangePicker = exports.ActionLogDateRangePicker = /*#__PURE__*/(0, _react.memo)(({
  dateRangePickerState,
  isDataLoading,
  onRefresh,
  onRefreshChange,
  onTimeChange,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const kibana = (0, _public.useKibana)();
  const {
    uiSettings
  } = kibana.services;
  const [commonlyUsedRanges] = (0, _react.useState)(() => {
    var _uiSettings$get$map, _uiSettings$get;
    return (_uiSettings$get$map = uiSettings === null || uiSettings === void 0 ? void 0 : (_uiSettings$get = uiSettings.get(_common2.UI_SETTINGS.TIMEPICKER_QUICK_RANGES)) === null || _uiSettings$get === void 0 ? void 0 : _uiSettings$get.map(({
      from,
      to,
      display
    }) => {
      return {
        start: from,
        end: to,
        label: display
      };
    })) !== null && _uiSettings$get$map !== void 0 ? _uiSettings$get$map : [];
  });
  return /*#__PURE__*/_react.default.createElement(DatePickerWrapper, {
    "data-test-subj": getTestId('super-date-picker')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    isLoading: isDataLoading,
    dateFormat: uiSettings.get('dateFormat'),
    commonlyUsedRanges: commonlyUsedRanges,
    end: dateRangePickerState.endDate,
    isPaused: !dateRangePickerState.autoRefreshOptions.enabled,
    onTimeChange: onTimeChange,
    onRefreshChange: onRefreshChange,
    refreshInterval: dateRangePickerState.autoRefreshOptions.duration,
    onRefresh: onRefresh,
    recentlyUsedRanges: dateRangePickerState.recentlyUsedDateRanges,
    start: dateRangePickerState.startDate,
    showUpdateButton: false,
    updateButtonProps: {
      iconOnly: true,
      fill: false
    },
    width: "auto"
  }))));
});
ActionLogDateRangePicker.displayName = 'ActionLogDateRangePicker';