"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EffectedPolicySelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _user_privileges = require("../../../common/components/user_privileges");
var _link_to_app = require("../../../common/components/endpoint/link_to_app");
var _routing = require("../../common/routing");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _hooks = require("../../../common/lib/kibana/hooks");
var _loader = require("../../../common/components/loader");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NOOP = () => {};
const DEFAULT_LIST_PROPS = {
  bordered: true,
  showIcons: false
};
const SEARCH_PROPS = {
  className: 'effected-policies-search'
};
const StyledEuiSelectable = _styledComponents.default.div`
  .effected-policies-search {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
  }
  .euiSelectableList {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    border-top-width: 0;
  }
`;
const StyledEuiFlexItemButtonGroup = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  @media only screen and (max-width: ${props => props.theme.eui.euiBreakpoints.m}) {
    align-items: center;
  }
`;
const StyledButtonGroup = (0, _styledComponents.default)(_eui.EuiButtonGroup)`
  display: flex;
  justify-content: right;
  .euiButtonGroupButton {
    padding-right: ${props => props.theme.eui.euiSizeL};
  }
`;
const EffectivePolicyFormContainer = _styledComponents.default.div`
  .policy-name .euiSelectableListItem__text {
    text-decoration: none !important;
    color: ${props => props.theme.eui.euiTextColor} !important;
  }
`;
const EffectedPolicySelect = exports.EffectedPolicySelect = /*#__PURE__*/(0, _react.memo)(({
  isGlobal,
  isPlatinumPlus,
  description,
  isLoading = false,
  onChange,
  listProps,
  options,
  selected = [],
  disabled = false,
  'data-test-subj': dataTestSubj,
  ...otherSelectableProps
}) => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const toggleGlobal = (0, _react.useMemo)(() => [{
    id: 'globalPolicy',
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.effectedPolicySelect.global', {
      defaultMessage: 'Global'
    }),
    iconType: isGlobal ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': getTestId('global')
  }, {
    id: 'perPolicy',
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.effectedPolicySelect.perPolicy', {
      defaultMessage: 'Per Policy'
    }),
    iconType: !isGlobal ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': getTestId('perPolicy')
  }], [getTestId, isGlobal]);
  const selectableOptions = (0, _react.useMemo)(() => {
    const isPolicySelected = new Set(selected.map(policy => policy.id));
    return options.map(policy => ({
      label: policy.name,
      className: 'policy-name',
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: (0, _eui.htmlIdGenerator)()(),
        onChange: NOOP,
        checked: isPolicySelected.has(policy.id),
        disabled: isGlobal || !isPlatinumPlus || disabled,
        "data-test-subj": `policy-${policy.id}-checkbox`
      }),
      append: canReadPolicyManagement ? /*#__PURE__*/_react.default.createElement(_link_to_app.LinkToApp, {
        href: getAppUrl({
          path: (0, _routing.getPolicyDetailPath)(policy.id)
        }),
        appPath: (0, _routing.getPolicyDetailPath)(policy.id),
        target: "_blank",
        "data-test-subj": getTestId('policyLink')
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.effectedPolicySelect.viewPolicyLinkLabel",
        defaultMessage: "View policy"
      })) : null,
      policy,
      checked: isPolicySelected.has(policy.id) ? 'on' : undefined,
      disabled: isGlobal || !isPlatinumPlus || disabled,
      'data-test-subj': `policy-${policy.id}`
    })).sort(({
      label: labelA
    }, {
      label: labelB
    }) => labelA.localeCompare(labelB));
  }, [canReadPolicyManagement, disabled, getAppUrl, getTestId, isGlobal, isPlatinumPlus, options, selected]);
  const handleOnPolicySelectChange = (0, _react.useCallback)(currentOptions => {
    onChange({
      isGlobal,
      selected: currentOptions.filter(opt => opt.checked).map(opt => opt.policy)
    });
  }, [isGlobal, onChange]);
  const handleGlobalButtonChange = (0, _react.useCallback)(selectedId => {
    onChange({
      isGlobal: selectedId === 'globalPolicy',
      selected
    });
  }, [onChange, selected]);
  const listBuilderCallback = (0, _react.useCallback)((list, search) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list);
  }, []);
  return /*#__PURE__*/_react.default.createElement(EffectivePolicyFormContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.effectedPolicySelect.assignmentSectionTitle",
    defaultMessage: "Assignment"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, description ? description : _i18n.i18n.translate('xpack.securitySolution.effectedPolicySelect.assignmentSectionDescription', {
    defaultMessage: 'Assign globally across all policies, or assign it to specific policies.'
  })))), /*#__PURE__*/_react.default.createElement(StyledEuiFlexItemButtonGroup, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(StyledButtonGroup, {
    legend: "Global Policy Toggle",
    options: toggleGlobal,
    idSelected: isGlobal ? 'globalPolicy' : 'perPolicy',
    onChange: handleGlobalButtonChange,
    color: "primary",
    "data-test-subj": getTestId('byPolicyGlobalButtonGroup'),
    isDisabled: disabled
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !isGlobal && (isLoading ? /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    size: "l",
    "data-test-subj": getTestId('policiesLoader')
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(StyledEuiSelectable, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({}, otherSelectableProps, {
    options: selectableOptions,
    listProps: listProps || DEFAULT_LIST_PROPS,
    onChange: handleOnPolicySelectChange,
    searchProps: SEARCH_PROPS,
    searchable: true,
    "data-test-subj": getTestId('policiesSelectable')
  }), listBuilderCallback)))));
});
EffectedPolicySelect.displayName = 'EffectedPolicySelect';