"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToArtifactInfo = void 0;
var _mapping = require("../../../../../common/endpoint/service/trusted_apps/mapping");
var _is_trusted_app = require("./is_trusted_app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapToArtifactInfo = _item => {
  var _item$os_types;
  const item = _item;
  const {
    name,
    created_by,
    created_at,
    updated_at,
    updated_by,
    description = '',
    entries
  } = item;
  return {
    name,
    created_by,
    created_at,
    updated_at,
    updated_by,
    description,
    comments: (0, _is_trusted_app.isTrustedApp)(item) ? [] : item.comments,
    entries: entries,
    os: (0, _is_trusted_app.isTrustedApp)(item) ? [item.os] : (_item$os_types = item.os_types) !== null && _item$os_types !== void 0 ? _item$os_types : [],
    effectScope: (0, _is_trusted_app.isTrustedApp)(item) ? item.effectScope : getEffectScopeFromExceptionItem(item)
  };
};
exports.mapToArtifactInfo = mapToArtifactInfo;
const getEffectScopeFromExceptionItem = item => {
  return (0, _mapping.tagsToEffectScope)(item.tags);
};