"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedComments = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _translations = require("../../../../detection_engine/rule_exceptions/utils/translations");
var _formatted_date = require("../../../../common/components/formatted_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomEuiAvatar = (0, _styledComponents.default)(_eui.EuiAvatar)`
  background-color: ${({
  theme
}) => theme.eui.euiColorLightShade} !important;
`;

/**
 * Formats ExceptionItem.comments into EuiCommentList format
 *
 * @param comments ExceptionItem.comments
 */
const getFormattedComments = comments => {
  return comments.map(commentItem => ({
    username: commentItem.created_by,
    timestamp: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: commentItem.created_at,
      dateFormat: "MMM D, YYYY"
    }),
    event: _translations.COMMENT_EVENT,
    timelineAvatar: /*#__PURE__*/_react.default.createElement(CustomEuiAvatar, {
      size: "s",
      name: commentItem.created_by
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, commentItem.comment)
  }));
};
exports.getFormattedComments = getFormattedComments;