"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePolicyNavLinks = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * creates the policy links for each policy listed in the artifact record by grabbing the
 * navigation data from the `policies` prop (if any)
 */
const usePolicyNavLinks = (artifact, policies) => {
  return (0, _react.useMemo)(() => {
    return artifact.effectScope.type === 'policy' ? artifact === null || artifact === void 0 ? void 0 : artifact.effectScope.policies.map(id => {
      return policies && policies[id] ? policies[id] :
      // else, unable to build a nav link, so just show id
      {
        children: id
      };
    }) : undefined;
  }, [artifact.effectScope, policies]);
};
exports.usePolicyNavLinks = usePolicyNavLinks;