"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subPluginClasses = void 0;
var _attack_discovery = require("./attack_discovery");
var _cases = require("./cases");
var _detections = require("./detections");
var _exceptions = require("./exceptions");
var _explore = require("./explore");
var _kubernetes = require("./kubernetes");
var _onboarding = require("./onboarding");
var _overview = require("./overview");
var _rules = require("./rules");
var _timelines = require("./timelines");
var _management = require("./management");
var _cloud_defend = require("./cloud_defend");
var _cloud_security_posture = require("./cloud_security_posture");
var _threat_intelligence = require("./threat_intelligence");
var _dashboards = require("./dashboards");
var _entity_analytics = require("./entity_analytics");
var _siem_migrations = require("./siem_migrations");
var _configurations = require("./configurations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * the plugin (defined in `plugin.tsx`) has many dependencies that can be loaded only when the app is being used.
 * By loading these later we can reduce the initial bundle size and allow users to delay loading these dependencies until they are needed.
 */

/**
 * The classes used to instantiate the sub plugins. These are grouped into a single object for the sake of bundling them in a single dynamic import.
 */
const subPluginClasses = exports.subPluginClasses = {
  AttackDiscovery: _attack_discovery.AttackDiscovery,
  Detections: _detections.Detections,
  Cases: _cases.Cases,
  Exceptions: _exceptions.Exceptions,
  Explore: _explore.Explore,
  Kubernetes: _kubernetes.Kubernetes,
  Onboarding: _onboarding.Onboarding,
  Overview: _overview.Overview,
  Rules: _rules.Rules,
  Timelines: _timelines.Timelines,
  Management: _management.Management,
  Dashboards: _dashboards.Dashboards,
  CloudDefend: _cloud_defend.CloudDefend,
  CloudSecurityPosture: _cloud_security_posture.CloudSecurityPosture,
  ThreatIntelligence: _threat_intelligence.ThreatIntelligence,
  EntityAnalytics: _entity_analytics.EntityAnalytics,
  Configurations: _configurations.Configurations,
  SiemMigrations: _siem_migrations.SiemMigrations
};