"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToGraphVisualization = void 0;
var _react = require("react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana = require("../../../../common/lib/kibana");
var _panel_keys = require("../constants/panel_keys");
var _telemetry = require("../../../../common/lib/telemetry");
var _graph_visualization = require("../../left/components/graph_visualization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns a callback to navigate to the graph visualization in the flyout
 */
const useNavigateToGraphVisualization = ({
  isFlyoutOpen,
  eventId,
  indexName,
  scopeId
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const right = (0, _react.useMemo)(() => ({
    id: _panel_keys.DocumentDetailsRightPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    }
  }), [eventId, indexName, scopeId]);
  const left = (0, _react.useMemo)(() => ({
    id: _panel_keys.DocumentDetailsLeftPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    },
    path: {
      tab: 'visualize',
      subTab: _graph_visualization.GRAPH_ID
    }
  }), [eventId, indexName, scopeId]);
  const navigateToGraphVisualization = (0, _react.useCallback)(() => {
    if (isFlyoutOpen) {
      openLeftPanel(left);
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutTabClicked, {
        location: scopeId,
        panel: 'left',
        tabId: 'visualize'
      });
    } else {
      openFlyout({
        right,
        left
      });
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
        location: scopeId,
        panel: 'left'
      });
    }
  }, [openFlyout, openLeftPanel, right, left, scopeId, telemetry, isFlyoutOpen]);
  return (0, _react.useMemo)(() => ({
    navigateToGraphVisualization
  }), [navigateToGraphVisualization]);
};
exports.useNavigateToGraphVisualization = useNavigateToGraphVisualization;