"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableTabColumns = exports.FIELD = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _table_tab = require("../tabs/table_tab");
var _table_field_name_cell = require("../components/table_field_name_cell");
var _table_field_value_cell = require("../components/table_field_value_cell");
var _cell_actions = require("../../shared/components/cell_actions");
var _test_ids = require("../components/test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD = exports.FIELD = _i18n.i18n.translate('xpack.securitySolution.flyout.table.fieldCellLabel', {
  defaultMessage: 'Field'
});
const VALUE = _i18n.i18n.translate('xpack.securitySolution.flyout.table.valueCellLabel', {
  defaultMessage: 'Value'
});
const PIN = _i18n.i18n.translate('xpack.securitySolution.flyout.table.pinCellLabel', {
  defaultMessage: 'Pin'
});
const UNPIN = _i18n.i18n.translate('xpack.securitySolution.flyout.table.unpinCellLabel', {
  defaultMessage: 'Unpin'
});
/**
 * Returns the columns for the table tab
 */
const getTableTabColumns = ({
  browserFields,
  eventId,
  scopeId,
  getLinkValue,
  ruleId,
  isRulePreview,
  onTogglePinned
}) => [{
  name: ' ',
  field: 'isPinned',
  render: (isPinned, data) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": isPinned ? UNPIN : PIN,
      className: isPinned ? 'flyout_table__unPinAction' : 'flyout_table__pinAction',
      iconType: isPinned ? 'pinFilled' : 'pin',
      color: "text",
      iconSize: "m",
      onClick: () => {
        onTogglePinned(data.field, isPinned ? 'unpin' : 'pin');
      },
      "data-test-subj": _test_ids.FLYOUT_TABLE_PIN_ACTION_TEST_ID
    });
  },
  width: '32px'
}, {
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, FIELD)),
  width: '30%',
  render: (field, data) => {
    return /*#__PURE__*/_react.default.createElement(_table_field_name_cell.TableFieldNameCell, {
      dataType: data.type,
      field: field
    });
  }
}, {
  field: 'values',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, VALUE)),
  render: (values, data) => {
    const fieldFromBrowserField = (0, _table_tab.getFieldFromBrowserField)(data.field, browserFields);
    return /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: data.field,
      value: values,
      isObjectArray: data.isObjectArray
    }, /*#__PURE__*/_react.default.createElement(_table_field_value_cell.TableFieldValueCell, {
      scopeId: scopeId,
      data: data,
      eventId: eventId,
      fieldFromBrowserField: fieldFromBrowserField,
      getLinkValue: getLinkValue,
      ruleId: ruleId,
      isRulePreview: isRulePreview,
      values: values
    }));
  }
}];
exports.getTableTabColumns = getTableTabColumns;