"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsSummaryRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _left = require("../../left");
var _formatted_number = require("../../../../common/components/formatted_number");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING = _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.insightSummaryLoadingAriaLabel', {
  defaultMessage: 'Loading'
});
const BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.insightSummaryButtonAriaLabel', {
  defaultMessage: 'Click to see more details'
});
/**
 * Panel showing summary information.
 * The default display is a text on the left and a count on the right, displayed with a clickable EuiBadge.
 * The left and right section can accept a ReactElement to allow for more complex display.
 * Should be used for Entities, Threat intelligence, Prevalence, Correlations and Results components under the Insights section.
 */
const InsightsSummaryRow = ({
  loading = false,
  error = false,
  value,
  text,
  expandedSubTab,
  'data-test-subj': dataTestSubj
}) => {
  const {
    navigateToLeftPanel: onClick,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInsightsTab,
    subTab: expandedSubTab
  });
  const textDataTestSubj = (0, _react.useMemo)(() => `${dataTestSubj}Text`, [dataTestSubj]);
  const loadingDataTestSubj = (0, _react.useMemo)(() => `${dataTestSubj}Loading`, [dataTestSubj]);
  const button = (0, _react.useMemo)(() => {
    const buttonDataTestSubj = `${dataTestSubj}Button`;
    const valueDataTestSubj = `${dataTestSubj}Value`;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof value === 'number' ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": BUTTON,
      onClick: onClick,
      flush: 'both',
      size: "xs",
      disabled: !isLinkEnabled,
      "data-test-subj": buttonDataTestSubj
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: value
    }))) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": valueDataTestSubj
    }, value));
  }, [dataTestSubj, onClick, value, isLinkEnabled]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      size: "m",
      isLoading: loading,
      contentAriaLabel: LOADING,
      "data-test-subj": loadingDataTestSubj
    });
  }
  if (error) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: 'spaceBetween',
    alignItems: 'center',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": textDataTestSubj,
    css: (0, _react2.css)`
          word-break: break-word;
          display: -webkit-box;
          -webkit-line-clamp: 1;
          -webkit-box-orient: vertical;
          overflow: hidden;
        `
  }, text), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, button));
};
exports.InsightsSummaryRow = InsightsSummaryRow;
InsightsSummaryRow.displayName = 'InsightsSummaryRow';