"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_expand_section = require("../hooks/use_expand_section");
var _correlations_overview = require("./correlations_overview");
var _prevalence_overview = require("./prevalence_overview");
var _threat_intelligence_overview = require("./threat_intelligence_overview");
var _test_ids = require("./test_ids");
var _entities_overview = require("./entities_overview");
var _expandable_section = require("./expandable_section");
var _context = require("../../shared/context");
var _utils = require("../../shared/utils");
var _event_kinds = require("../../shared/constants/event_kinds");
var _guided_onboarding_tour = require("../../../../common/components/guided_onboarding_tour");
var _tour_config = require("../../../../common/components/guided_onboarding_tour/tour_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KEY = 'insights';

/**
 * Insights section under overview tab. It contains entities, threat intelligence, prevalence and correlations.
 */
const InsightsSection = exports.InsightsSection = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const {
    activeStep,
    isTourShown
  } = (0, _guided_onboarding_tour.useTourContext)();
  const isGuidedOnboardingTourShown = isTourShown(_tour_config.SecurityStepId.alertsCases) && activeStep === _tour_config.AlertsCasesTourSteps.createCase;
  const expanded = (0, _use_expand_section.useExpandSection)({
    title: KEY,
    defaultValue: false
  }) || isGuidedOnboardingTourShown;
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.sectionTitle",
      defaultMessage: "Insights"
    }),
    localStorageKey: KEY,
    "data-test-subj": _test_ids.INSIGHTS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_entities_overview.EntitiesOverview, null), eventKind === _event_kinds.EventKind.signal && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_threat_intelligence_overview.ThreatIntelligenceOverview, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_correlations_overview.CorrelationsOverview, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_prevalence_overview.PrevalenceOverview, null));
});
InsightsSection.displayName = 'InsightsSection';