"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventKindDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../../shared/context");
var _event_utils = require("../utils/event_utils");
var _utils = require("../../shared/utils");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Display description of a document at the event kind level
 * Shows the ecs description of the event kind, and a list of event categories
 */
const EventKindDescription = ({
  eventKind
}) => {
  const {
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const eventCategories = (0, _react.useMemo)(() => (0, _utils.getFieldArray)(getFieldsData('event.category')), [getFieldsData]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.EVENT_KIND_DESCRIPTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": _test_ids.EVENT_KIND_DESCRIPTION_TEXT_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("h5", null, (0, _lodash.startCase)(eventKind))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (0, _event_utils.getEcsAllowedValueDescription)('event.kind', eventKind)), eventCategories.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Event category",
    id: "xpack.securitySolution.flyout.right.eventCategoryText"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    "data-test-subj": _test_ids.EVENT_KIND_DESCRIPTION_CATEGORIES_TEST_ID
  }, eventCategories.map((category, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `event-category-${category}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _event_utils.getEcsAllowedValueDescription)('event.category', category)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, category, idx !== eventCategories.length - 1 && ',')))))));
};
exports.EventKindDescription = EventKindDescription;
EventKindDescription.displayName = 'EventKindDescription';