"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePaginatedAlerts = void 0;
var _react = require("react");
var _use_fetch_alerts = require("./use_fetch_alerts");
var _use_pagination_and_sorting = require("./use_pagination_and_sorting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Adds pagination and sorting state to useFetchAlerts. It is used in alerts table local to correlation details
 */
const usePaginatedAlerts = alertIds => {
  const {
    setPagination,
    pagination,
    pageSizeOptions
  } = (0, _use_pagination_and_sorting.usePagination)();
  const {
    sorting,
    sortConfig,
    setSorting
  } = (0, _use_pagination_and_sorting.useSorting)();
  const {
    data,
    totalItemCount,
    loading,
    error
  } = (0, _use_fetch_alerts.useFetchAlerts)({
    alertIds,
    from: pagination.pageIndex * pagination.pageSize,
    size: pagination.pageSize,
    sort: sortConfig
  });
  const paginationConfig = (0, _react.useMemo)(() => {
    return {
      ...pagination,
      pageSizeOptions,
      totalItemCount
    };
  }, [pageSizeOptions, pagination, totalItemCount]);
  return {
    paginationConfig,
    setPagination,
    setSorting,
    loading,
    data,
    sorting,
    error
  };
};
exports.usePaginatedAlerts = usePaginatedAlerts;