"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAlerts = void 0;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _lodash = require("lodash");
var _kibana = require("../../../../common/lib/kibana");
var _find_alerts = require("../services/find_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns alerts based on provided ids with support for pagination. Uses react-query internally.
 */
const useFetchAlerts = ({
  alertIds,
  from,
  size,
  sort
}) => {
  const QUERY_KEY = `useFetchAlerts`;
  const {
    services: {
      data: dataService
    }
  } = (0, _kibana.useKibana)();
  const findAlerts = (0, _react.useMemo)(() => (0, _find_alerts.createFindAlerts)(dataService.search), [dataService.search]);
  const {
    data,
    isLoading,
    isError
  } = (0, _reactQuery.useQuery)([QUERY_KEY, alertIds, from, size, sort], async ({
    signal
  }) => findAlerts({
    signal,
    alertIds,
    from,
    size,
    sort
  }), {
    keepPreviousData: true
  });
  return (0, _react.useMemo)(() => {
    var _data$hits, _data$hits2;
    const total = data === null || data === void 0 ? void 0 : (_data$hits = data.hits) === null || _data$hits === void 0 ? void 0 : _data$hits.total;
    return {
      loading: isLoading,
      error: isError,
      data: (data === null || data === void 0 ? void 0 : (_data$hits2 = data.hits) === null || _data$hits2 === void 0 ? void 0 : _data$hits2.hits) || [],
      totalItemCount: (0, _lodash.isNumber)(total) ? total : 0 || 0
    };
  }, [data, isError, isLoading]);
};
exports.useFetchAlerts = useFetchAlerts;