"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = exports.IsolateHostPanelHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _agent_type_integration = require("../../../common/components/endpoint/agents/agent_type_integration");
var _use_alert_response_actions_support = require("../../../common/hooks/endpoint/use_alert_response_actions_support");
var _context = require("./context");
var _test_ids = require("./test_ids");
var _flyout_header = require("../../shared/components/flyout_header");
var _endpoint = require("../../../common/components/endpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details expandable right section header for the isolate host panel
 */
const PanelHeader = () => {
  const {
    isolateAction,
    dataFormattedForFieldBrowser: data
  } = (0, _context.useIsolateHostPanelContext)();
  return /*#__PURE__*/_react.default.createElement(IsolateHostPanelHeader, {
    isolateAction: isolateAction,
    data: data
  });
};
exports.PanelHeader = PanelHeader;
const IsolateHostPanelHeader = ({
  isolateAction,
  data
}) => {
  const {
    details: {
      agentType
    }
  } = (0, _use_alert_response_actions_support.useAlertResponseActionsSupport)(data);
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "flyoutHostIsolationHeaderTitle"
  }, isolateAction === 'isolateHost' ? _endpoint.ISOLATE_HOST : _endpoint.UNISOLATE_HOST, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_agent_type_integration.AgentTypeIntegration, {
    agentType: agentType,
    layout: "horizontal",
    "data-test-subj": "flyoutHostIsolationHeaderIntegration"
  })));
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": _test_ids.FLYOUT_HEADER_TITLE_TEST_ID
  }, title)));
};
exports.IsolateHostPanelHeader = IsolateHostPanelHeader;