"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertReason = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _context = require("./context");
var _get_row_renderer = require("../../../timelines/components/timeline/body/renderers/get_row_renderer");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _flyout_error = require("../../shared/components/flyout_error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Alert reason renderer on a preview panel on top of the right section of expandable flyout
 */
const AlertReason = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    dataAsNestedObject,
    scopeId
  } = (0, _context.useAlertReasonPanelContext)();
  const renderer = (0, _react.useMemo)(() => (0, _get_row_renderer.getRowRenderer)({
    data: dataAsNestedObject,
    rowRenderers: _renderers.defaultRowRenderers
  }), [dataAsNestedObject]);
  const rowRenderer = (0, _react.useMemo)(() => renderer ? renderer.renderRow({
    contextId: 'event-details',
    data: dataAsNestedObject,
    scopeId
  }) : null, [renderer, dataAsNestedObject, scopeId]);
  if (!renderer) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: false
    }, /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, null));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": _test_ids.ALERT_REASON_BODY_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.preview.alertReason.panelTitle",
    defaultMessage: "Alert reason"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          overflow-x: auto;
          padding-block: ${euiTheme.size.s};
        `
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: 'eui-displayInlineBlock'
  }, rowRenderer)));
};
exports.AlertReason = AlertReason;
AlertReason.displayName = 'AlertReason';