"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsTableUtilityBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _utility_bar = require("../../../common/components/utility_bar");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsTableUtilityBar = ({
  onRefresh,
  totalExceptionLists,
  setSort,
  sort,
  sortFields
}) => {
  var _sortFields$find;
  const selectedSortField = sortFields === null || sortFields === void 0 ? void 0 : sortFields.find(sortField => sortField.field === (sort === null || sort === void 0 ? void 0 : sort.field));
  return /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    border: true
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "showingExceptionLists"
  }, i18n.SHOWING_EXCEPTION_LISTS(totalExceptionLists))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "refreshRulesAction",
    iconSide: "left",
    iconType: "refresh",
    onClick: onRefresh
  }, i18n.REFRESH_EXCEPTIONS_TABLE))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, sort && /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "sortExceptions",
    iconSide: "right",
    iconType: sort.order === 'asc' ? 'sortUp' : 'sortDown',
    popoverPanelPaddingSize: 's',
    popoverContent: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: sortFields === null || sortFields === void 0 ? void 0 : sortFields.map(item => {
        const isSelectedSortItem = (selectedSortField === null || selectedSortField === void 0 ? void 0 : selectedSortField.field) === item.field;
        let nextSortOrder = item.defaultOrder;
        if (isSelectedSortItem) {
          nextSortOrder = sort.order === 'asc' ? 'desc' : 'asc';
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: item.field,
          onClick: () => setSort === null || setSort === void 0 ? void 0 : setSort({
            field: item.field,
            order: nextSortOrder
          })
        }, /*#__PURE__*/_react.default.createElement(SortMenuItem, null, item.label, ' ', (selectedSortField === null || selectedSortField === void 0 ? void 0 : selectedSortField.field) === item.field && /*#__PURE__*/_react.default.createElement(SortIcon, {
          type: sort.order === 'asc' ? 'sortUp' : 'sortDown'
        })));
      })
    })
  }, /*#__PURE__*/_react.default.createElement(SortMenuItem, null, i18n.SORT_BY, ' ', sortFields === null || sortFields === void 0 ? void 0 : (_sortFields$find = sortFields.find(sortField => sortField.field === sort.field)) === null || _sortFields$find === void 0 ? void 0 : _sortFields$find.label))))));
};
exports.ExceptionsTableUtilityBar = ExceptionsTableUtilityBar;
const SortMenuItem = (0, _styledComponents.default)('div')`
  display: flex;
  align-items: center;
`;
const SortIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-left: 8px;
`;
ExceptionsTableUtilityBar.displayName = 'ExceptionsTableUtilityBar';