"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStoreEntityTypes = exports.useRiskEngineEntityTypes = exports.useAssetCriticalityEntityTypes = void 0;
var _react = require("react");
var _utils = require("../../../common/entity_analytics/asset_criticality/utils");
var _utils2 = require("../../../common/entity_analytics/risk_engine/utils");
var _utils3 = require("../../../common/entity_analytics/entity_store/utils");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStoreEntityTypes = () => {
  const experimentalFeatures = (0, _use_experimental_features.useEnableExperimental)();
  return (0, _react.useMemo)(() => (0, _utils3.getEnabledStoreEntityTypes)(experimentalFeatures), [experimentalFeatures]);
};
exports.useStoreEntityTypes = useStoreEntityTypes;
const useRiskEngineEntityTypes = () => {
  const experimentalFeatures = (0, _use_experimental_features.useEnableExperimental)();
  return (0, _react.useMemo)(() => (0, _utils2.getRiskEngineEntityTypes)(experimentalFeatures), [experimentalFeatures]);
};
exports.useRiskEngineEntityTypes = useRiskEngineEntityTypes;
const useAssetCriticalityEntityTypes = () => {
  const experimentalFeatures = (0, _use_experimental_features.useEnableExperimental)();
  return (0, _react.useMemo)(() => (0, _utils.getAssetCriticalityEntityTypes)(experimentalFeatures), [experimentalFeatures]);
};
exports.useAssetCriticalityEntityTypes = useAssetCriticalityEntityTypes;