"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installRiskScore = void 0;
var _constants = require("../../../../common/constants");
var _search_strategy = require("../../../../common/search_strategy");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toastLifeTimeMs = 600000;
const installRiskScore = ({
  errorMessage,
  http,
  options,
  renderDocLink,
  signal,
  startServices
}) => {
  const {
    notifications
  } = startServices;
  return http.post(_constants.INTERNAL_RISK_SCORE_URL, {
    version: '1',
    body: JSON.stringify(options),
    signal
  }).then(result => {
    const resp = result.reduce((acc, curr) => {
      const [[key, res]] = Object.entries(curr);
      if (res.success) {
        return res.success != null ? {
          ...acc,
          success: [...acc.success, `${key}`]
        } : acc;
      } else {
        var _res$error;
        return res.error != null ? {
          ...acc,
          error: [...acc.error, `${key}: ${res === null || res === void 0 ? void 0 : (_res$error = res.error) === null || _res$error === void 0 ? void 0 : _res$error.message}`]
        } : acc;
      }
    }, {
      success: [],
      error: []
    });
    if (resp.error.length > 0) {
      notifications.toasts.addError(new Error(errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.INSTALLATION_ERROR), {
        title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.INSTALLATION_ERROR,
        toastMessage: renderDocLink ? renderDocLink(resp.error.join(', ')) : resp.error.join(', '),
        toastLifeTimeMs
      });
    } else {
      notifications.toasts.addSuccess({
        'data-test-subj': `${options.riskScoreEntity}EnableSuccessToast`,
        title: options.riskScoreEntity === _search_strategy.EntityType.user ? _translations.USER_RISK_SCORES_ENABLED_TITLE : _translations.HOST_RISK_SCORES_ENABLED_TITLE,
        text: (0, _translations.RISK_SCORES_ENABLED_TEXT)(resp.success.join(', '))
      });
    }
  }).catch(e => {
    var _e$body, _e$body2;
    notifications.toasts.addError(new Error(errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.INSTALLATION_ERROR), {
      title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.INSTALLATION_ERROR,
      toastMessage: renderDocLink ? renderDocLink(e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) : e === null || e === void 0 ? void 0 : (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message,
      toastLifeTimeMs
    });
  });
};
exports.installRiskScore = installRiskScore;