"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsLearnMoreLink = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsLearnMoreLinkComponent = ({
  title
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const entityAnalyticsLinks = docLinks.links.securitySolution.entityAnalytics;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: entityAnalyticsLinks.entityRiskScoring
  }, title ? title : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.learnMore",
    defaultMessage: "Learn more about entity risk scoring"
  }));
};
const EntityAnalyticsLearnMoreLink = exports.EntityAnalyticsLearnMoreLink = /*#__PURE__*/_react.default.memo(EntityAnalyticsLearnMoreLinkComponent);
EntityAnalyticsLearnMoreLink.displayName = 'EntityAnalyticsLearnMoreLink';