"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskEntityTranslationText = exports.getRiskEntityTranslation = exports.USERS = exports.USER = exports.SERVICES = exports.SERVICE = exports.RISK_SCORING_TITLE = exports.RISK_SCORE_TITLE = exports.HOSTS = exports.HOST = exports.ENTITY_RISK_LEVEL = exports.ENTITY = exports.ENTITIES = exports.ALERTS = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../../../common/entity_analytics/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST = exports.HOST = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.hostTitle', {
  defaultMessage: 'Host'
});
const HOSTS = exports.HOSTS = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.hosts', {
  defaultMessage: 'Hosts'
});
const USER = exports.USER = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.userTitle', {
  defaultMessage: 'User'
});
const USERS = exports.USERS = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.users', {
  defaultMessage: 'Users'
});
const SERVICE = exports.SERVICE = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.serviceTitle', {
  defaultMessage: 'Service'
});
const SERVICES = exports.SERVICES = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.services', {
  defaultMessage: 'Services'
});
const ENTITY = exports.ENTITY = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.entityTitle', {
  defaultMessage: 'Entity'
});
const ENTITIES = exports.ENTITIES = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.entities', {
  defaultMessage: 'Entities'
});
const RISK_SCORE_TITLE = riskEntity => _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.riskScoreTitle', {
  defaultMessage: '{riskEntity} Risk Score',
  values: {
    riskEntity: getRiskEntityTranslation(riskEntity)
  }
});
exports.RISK_SCORE_TITLE = RISK_SCORE_TITLE;
const RISK_SCORING_TITLE = exports.RISK_SCORING_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.riskScoringTitle', {
  defaultMessage: 'Entity Risk Scoring'
});
const ENTITY_RISK_LEVEL = riskEntity => riskEntity ? _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.riskLevelTitle', {
  defaultMessage: '{riskEntity} risk level',
  values: {
    riskEntity: getRiskEntityTranslation(riskEntity)
  }
}) : _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.noEntity.riskLevelTitle', {
  defaultMessage: 'Risk level'
});
exports.ENTITY_RISK_LEVEL = ENTITY_RISK_LEVEL;
const getRiskEntityTranslation = (riskEntity, lowercase = false, plural = false) => {
  const text = getRiskEntityTranslationText(riskEntity, plural);
  return lowercase ? text.toLowerCase() : text;
};
exports.getRiskEntityTranslation = getRiskEntityTranslation;
const getRiskEntityTranslationText = (riskEntity, plural) => {
  switch (riskEntity) {
    case _types.EntityType.host:
      return plural ? HOSTS : HOST;
    case _types.EntityType.user:
      return plural ? USERS : USER;
    case _types.EntityType.service:
      return plural ? SERVICES : SERVICE;
    default:
      return plural ? ENTITIES : ENTITY;
  }
};
exports.getRiskEntityTranslationText = getRiskEntityTranslationText;
const ALERTS = exports.ALERTS = _i18n.i18n.translate('xpack.securitySolution.riskScore.overview.alerts', {
  defaultMessage: 'Alerts'
});