"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityInfo = void 0;
var _reactRedux = require("react-redux");
var _types = require("../../../../common/entity_analytics/types");
var _redirect_to_users = require("../../../common/components/link_to/redirect_to_users");
var _model = require("../../../explore/users/store/model");
var _redirect_to_hosts = require("../../../common/components/link_to/redirect_to_hosts");
var _model2 = require("../../../explore/hosts/store/model");
var _store = require("../../../explore/users/store");
var _store2 = require("../../../explore/hosts/store");
var _types2 = require("../../../app/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEntityInfo = riskEntity => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const tableQueryIds = {
    tableQueryId: `${riskEntity}RiskDashboardTable`,
    kpiQueryId: `${riskEntity}HeaderRiskScoreKpiQuery`
  };
  if (riskEntity === _types.EntityType.host) {
    return {
      linkProps: {
        deepLinkId: _types2.SecurityPageName.hosts,
        path: (0, _redirect_to_hosts.getTabsOnHostsUrl)(_model2.HostsTableType.risk),
        onClick: () => {
          dispatch(_store2.hostsActions.updateHostRiskScoreSeverityFilter({
            severitySelection: [],
            hostsType: _model2.HostsType.page
          }));
        }
      },
      ...tableQueryIds
    };
  } else if (riskEntity === _types.EntityType.user) {
    return {
      linkProps: {
        deepLinkId: _types2.SecurityPageName.users,
        path: (0, _redirect_to_users.getTabsOnUsersUrl)(_model.UsersTableType.risk),
        onClick: () => {
          dispatch(_store.usersActions.updateUserRiskScoreSeverityFilter({
            severitySelection: []
          }));
        }
      },
      ...tableQueryIds
    };
  }
  return {
    linkProps: undefined,
    ...tableQueryIds
  };
};
exports.useEntityInfo = useEntityInfo;