"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userHasRiskEngineReadPermissions = void 0;
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const userHasRiskEngineReadPermissions = privileges => {
  if (privileges.isLoading) {
    return false;
  }
  if (privileges.hasAllRequiredPrivileges) {
    return true;
  }
  const {
    indexPrivileges: missingIndexPrivileges
  } = privileges.missingPrivileges;
  const isMissingReadPrivilege = missingIndexPrivileges.find(([indexName, indexPrivileges]) => indexName === _risk_engine.RISK_SCORE_INDEX_PATTERN && indexPrivileges.includes('read'));
  return !isMissingReadPrivilege;
};
exports.userHasRiskEngineReadPermissions = userHasRiskEngineReadPermissions;