"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStartDateFromRiskScore = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * return start date of risk scoring by calculating the difference between risk score timestamp and risk range start date
 * return the same risk range start date if it's a date
 * return now-30d if there are erros in parsing the date
 */
const getStartDateFromRiskScore = ({
  riskRangeStart,
  riskScoreTimestamp
}) => {
  try {
    if ((0, _moment.default)(riskRangeStart).isValid()) {
      return riskRangeStart;
    }
    const startDateFromNow = _datemath.default.parse(riskRangeStart);
    if (!startDateFromNow || !startDateFromNow.isValid()) {
      throw new Error('error parsing risk range start date');
    }
    const now = (0, _moment.default)();
    const rangeInHours = now.diff(startDateFromNow, 'minutes');
    const riskScoreDate = _datemath.default.parse(riskScoreTimestamp);
    if (!riskScoreDate || !riskScoreDate.isValid()) {
      throw new Error('error parsing risk score timestamp');
    }
    const startDate = riskScoreDate.subtract(rangeInHours, 'minutes');
    return startDate.utc().toISOString();
  } catch (error) {
    return 'now-30d';
  }
};
exports.getStartDateFromRiskScore = getStartDateFromRiskScore;