"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenAlertType = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/timelines-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nonFlattenedFormatParamsFields = ['related_integrations', 'threat_mapping'];

/**
 * Returns true if the field is related to kibana.alert.rule.parameters.
 * This code is similar to x-pack/platform/plugins/shared/timelines/common/utils/field_formatters.ts and once
 * the Security Solution and Timelines plugins are merged we should probably share the code.
 */
const isRuleParametersFieldOrSubfield = (field, prependField) => ((prependField === null || prependField === void 0 ? void 0 : prependField.includes(_ruleDataUtils.ALERT_RULE_PARAMETERS)) || field === _ruleDataUtils.ALERT_RULE_PARAMETERS) && !nonFlattenedFormatParamsFields.includes(field);

/**
 * Recursive function that processes all the fields from an Alert and returns a flattened object as a Record<string, string[]>.
 * This is used in the AI for SOC alert summary page, in the getPromptContext when passing data to the assistant.
 * The logic is similar to x-pack/platform/plugins/shared/timelines/common/utils/field_formatters.ts but for an Alert type.
 */
const flattenAlertType = (obj, prependField) => {
  const resultMap = {};
  const allFields = Object.keys(obj);
  for (let i = 0; i < allFields.length; i++) {
    const field = allFields[i];
    const value = obj[field];
    const dotField = prependField ? `${prependField}.${field}` : field;
    const valueIntoObjectArrayOfStrings = (0, _common.toObjectArrayOfStrings)(value);
    const valueAsStringArray = valueIntoObjectArrayOfStrings.map(({
      str
    }) => str);
    const valueIsObjectArray = valueIntoObjectArrayOfStrings.some(o => o.isObjectArray);
    if (!valueIsObjectArray) {
      // Handle simple fields
      resultMap[dotField] = valueAsStringArray;
    } else {
      // Process nested fields
      const isRuleParameters = isRuleParametersFieldOrSubfield(field, prependField);
      const subField = isRuleParameters ? dotField : undefined;
      const subValue = Array.isArray(value) ? value[0] : value;
      const subValueIntoObjectArrayOfStrings = (0, _common.toObjectArrayOfStrings)(subValue);
      const subValueAsStringArray = subValueIntoObjectArrayOfStrings.map(({
        str
      }) => str);
      const subValueIsObjectArray = subValueIntoObjectArrayOfStrings.some(o => o.isObjectArray);
      if (!subValueIsObjectArray) {
        resultMap[dotField] = subValueAsStringArray;
      } else {
        const nestedFieldValuePairs = flattenAlertType(subValue, subField);
        const nestedFields = Object.keys(nestedFieldValuePairs);
        for (let j = 0; j < nestedFields.length; j++) {
          const nestedField = nestedFields[j];
          resultMap[nestedField] = nestedFieldValuePairs[nestedField];
        }
      }
    }
  }
  return resultMap;
};
exports.flattenAlertType = flattenAlertType;