"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_UNAUTHENTICATED_TITLE = exports.USER_UNAUTHENTICATED_MSG_BODY = exports.READ_ONLY_BADGE_TOOLTIP = exports.PAGE_TITLE = exports.NO_INDEX_TITLE = exports.NEEDS_SIGNALS_INDEX = exports.NEEDS_SIGNALS_AND_LISTS_INDEXES = exports.NEEDS_LISTS_INDEXES = exports.NEEDS_INDEX_PERMISSIONS = exports.GO_TO_DOCUMENTATION = exports.BUTTON_MANAGE_RULES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const READ_ONLY_BADGE_TOOLTIP = exports.READ_ONLY_BADGE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alerts.badge.readOnly.tooltip', {
  defaultMessage: 'Unable to update alerts'
});
const PAGE_TITLE = exports.PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.detectionsPageTitle', {
  defaultMessage: 'Alerts'
});
const BUTTON_MANAGE_RULES = exports.BUTTON_MANAGE_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.buttonManageRules', {
  defaultMessage: 'Manage rules'
});
const GO_TO_DOCUMENTATION = exports.GO_TO_DOCUMENTATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.goToDocumentationButton', {
  defaultMessage: 'View documentation'
});
const USER_UNAUTHENTICATED_MSG_BODY = exports.USER_UNAUTHENTICATED_MSG_BODY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.userUnauthenticatedMsgBody', {
  defaultMessage: 'You do not have the required permissions for viewing the detection engine. For more help, contact your administrator.'
});
const USER_UNAUTHENTICATED_TITLE = exports.USER_UNAUTHENTICATED_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.userUnauthenticatedTitle', {
  defaultMessage: 'Detection engine permissions required'
});
const NEEDS_INDEX_PERMISSIONS = additionalContext => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsIndexPermissionsMessage', {
  values: {
    additionalContext
  },
  defaultMessage: 'To use the detection engine, a user with the required cluster and index privileges must first access this page. {additionalContext} For more help, contact your Elastic Stack administrator.'
});
exports.NEEDS_INDEX_PERMISSIONS = NEEDS_INDEX_PERMISSIONS;
const NEEDS_SIGNALS_AND_LISTS_INDEXES = exports.NEEDS_SIGNALS_AND_LISTS_INDEXES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsSignalsAndListsIndexesMessage', {
  defaultMessage: 'You need permissions for the signals and lists indices.'
});
const NEEDS_SIGNALS_INDEX = exports.NEEDS_SIGNALS_INDEX = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsSignalsIndexMessage', {
  defaultMessage: 'You need permissions for the signals index.'
});
const NEEDS_LISTS_INDEXES = exports.NEEDS_LISTS_INDEXES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsListsIndexesMessage', {
  defaultMessage: 'You need permissions for the lists indices.'
});
const NO_INDEX_TITLE = exports.NO_INDEX_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.noIndexTitle', {
  defaultMessage: 'Let’s set up your detection engine'
});