"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Detections = exports.DETECTIONS_TABLE_IDS = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _local_storage = require("../timelines/containers/local_storage");
var _routes = require("./routes");
var _migrations = require("./migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTIONS_TABLE_IDS = exports.DETECTIONS_TABLE_IDS = [_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage, _securitysolutionDataTable.TableId.alertsOnAlertsPage];
class Detections {
  setup() {}
  async start(storage, plugins) {
    await (0, _migrations.runDetectionMigrations)(storage, plugins);
    return {
      storageDataTables: {
        tableById: (0, _local_storage.getDataTablesInStorageByIds)(storage, DETECTIONS_TABLE_IDS)
      },
      routes: _routes.routes
    };
  }
}
exports.Detections = Detections;