"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleFromTimeline = exports.RULE_FROM_TIMELINE_URL_PARAM = exports.RULE_FROM_EQL_URL_PARAM = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _kuery = require("../../../../common/lib/kuery");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _containers = require("../../../../sourcerer/containers");
var _store = require("../../../../sourcerer/store");
var _helpers = require("../../../../timelines/components/open_timeline/helpers");
var _helpers2 = require("../../../../common/utils/global_query_string/helpers");
var _helpers3 = require("../../../../timelines/components/timeline/helpers");
var _query_bar = require("../../../../timelines/components/timeline/query_bar");
var _model = require("../../../../sourcerer/store/model");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_FROM_TIMELINE_URL_PARAM = exports.RULE_FROM_TIMELINE_URL_PARAM = 'createRuleFromTimeline';
const RULE_FROM_EQL_URL_PARAM = exports.RULE_FROM_EQL_URL_PARAM = 'createRuleFromEql';
const useRuleFromTimeline = setRuleQuery => {
  var _experimentalDataView;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    browserFields: oldBrowserFields,
    dataViewId: oldDataViewId,
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.timeline);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const dataViewId = newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView === null || experimentalDataView === void 0 ? void 0 : experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : '' : oldDataViewId;
  const isEql = (0, _react.useRef)(false);

  // selectedTimeline = timeline to set rule from
  const [selectedTimeline, setRuleFromTimeline] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(false);
  const onOpenTimeline = (0, _react.useCallback)(timeline => {
    // will already be true if timeline set from url
    setLoading(true);
    setRuleFromTimeline(timeline);
    if (timeline.dataViewId !== dataViewId && !(0, _fp.isEmpty)(timeline.indexNames)) {
      // let sourcerer manage the selected browser fields by setting timeline scope to the selected timeline data view
      // sourcerer handles the logic of if the fields have been fetched or need to be fetched
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _model.SourcererScopeName.timeline,
        selectedDataViewId: timeline.dataViewId,
        selectedPatterns: timeline.indexNames
      }));
    }
  }, [dataViewId, dispatch]);

  // start browser field management
  const [originalDataView] = (0, _react.useState)({
    dataViewId,
    selectedPatterns
  });
  const selectedDataViewBrowserFields = (0, _react.useMemo)(() => selectedTimeline == null || (0, _fp.isEmpty)(browserFields) || selectedTimeline.dataViewId !== null && dataViewId !== null && dataViewId !== selectedTimeline.dataViewId ? null : browserFields, [browserFields, dataViewId, selectedTimeline]);
  // end browser field management

  const getInitialUrlParamValue = (0, _helpers2.useGetInitialUrlParamValue)(RULE_FROM_TIMELINE_URL_PARAM);
  const timelineIdFromUrl = (0, _react.useMemo)(getInitialUrlParamValue, [getInitialUrlParamValue]);
  const getInitialUrlParamValueEql = (0, _helpers2.useGetInitialUrlParamValue)(RULE_FROM_EQL_URL_PARAM);
  const timelineIdFromUrlEql = (0, _react.useMemo)(getInitialUrlParamValueEql, [getInitialUrlParamValueEql]);

  // start set rule
  const handleSetRuleFromTimeline = (0, _react.useCallback)(() => {
    if (selectedTimeline == null || selectedDataViewBrowserFields == null) return;
    try {
      const queryRuleFromTimeline = () => {
        var _selectedTimeline$kql, _selectedTimeline$kql2, _selectedTimeline$kql3, _selectedTimeline$kql4, _selectedTimeline$kql5, _selectedTimeline$kql6, _selectedTimeline$fil;
        return {
          dataProviders: selectedTimeline.dataProviders != null && selectedTimeline.dataProviders.length > 0 ? (0, _kuery.convertKueryToElasticSearchQuery)((0, _helpers3.buildGlobalQuery)(selectedTimeline.dataProviders, selectedDataViewBrowserFields), {
            fields: [],
            title: selectedPatterns.join(',')
          }) : '',
          query: {
            query: (_selectedTimeline$kql = (_selectedTimeline$kql2 = selectedTimeline.kqlQuery.filterQuery) === null || _selectedTimeline$kql2 === void 0 ? void 0 : (_selectedTimeline$kql3 = _selectedTimeline$kql2.kuery) === null || _selectedTimeline$kql3 === void 0 ? void 0 : _selectedTimeline$kql3.expression) !== null && _selectedTimeline$kql !== void 0 ? _selectedTimeline$kql : '',
            language: (_selectedTimeline$kql4 = (_selectedTimeline$kql5 = selectedTimeline.kqlQuery.filterQuery) === null || _selectedTimeline$kql5 === void 0 ? void 0 : (_selectedTimeline$kql6 = _selectedTimeline$kql5.kuery) === null || _selectedTimeline$kql6 === void 0 ? void 0 : _selectedTimeline$kql6.kind) !== null && _selectedTimeline$kql4 !== void 0 ? _selectedTimeline$kql4 : 'kuery'
          },
          filters: (_selectedTimeline$fil = selectedTimeline.filters) !== null && _selectedTimeline$fil !== void 0 ? _selectedTimeline$fil : [],
          eqlOptions: {}
        };
      };
      const eqlRuleFromTimeline = () => {
        var _selectedTimeline$eql;
        return {
          dataProviders: '',
          query: {
            query: (_selectedTimeline$eql = selectedTimeline.eqlOptions.query) !== null && _selectedTimeline$eql !== void 0 ? _selectedTimeline$eql : '',
            language: 'eql'
          },
          filters: [],
          eqlOptions: {
            eqlOptions: selectedTimeline.eqlOptions
          }
        };
      };
      const data = isEql.current ? eqlRuleFromTimeline() : queryRuleFromTimeline();
      setLoading(false);
      setRuleQuery({
        index: selectedPatterns,
        queryBar: {
          filters: data.dataProviders !== '' ? [...data.filters, (0, _query_bar.getDataProviderFilter)(data.dataProviders)] : data.filters,
          query: data.query,
          saved_id: null
        },
        ...data.eqlOptions
      });
    } catch (error) {
      setLoading(false);
      addError(error, {
        toastMessage: _i18n.i18n.translate('xpack.securitySolution.ruleFromTimeline.error.toastMessage', {
          defaultMessage: 'Failed to create rule from timeline with id: {id}',
          values: {
            id: selectedTimeline.id
          }
        }),
        title: _i18n.i18n.translate('xpack.securitySolution.ruleFromTimeline.error.title', {
          defaultMessage: 'Failed to import rule from timeline'
        })
      });
    }

    // reset and default to query since this is the only query type the user can set after url has been initialized
    isEql.current = false;
    // reset timeline data view once complete
    if (originalDataView.dataViewId !== dataViewId) {
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _model.SourcererScopeName.timeline,
        selectedDataViewId: originalDataView.dataViewId,
        selectedPatterns: originalDataView.selectedPatterns
      }));
    }
  }, [addError, dataViewId, dispatch, originalDataView.dataViewId, originalDataView.selectedPatterns, selectedDataViewBrowserFields, selectedPatterns, selectedTimeline, setRuleQuery]);
  (0, _react.useEffect)(() => {
    // ensure browser fields are correct before updating the rule
    if (selectedDataViewBrowserFields != null) {
      handleSetRuleFromTimeline();
    }
  }, [handleSetRuleFromTimeline, selectedDataViewBrowserFields]);
  // end set rule

  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  const getTimelineById = (0, _react.useCallback)(timelineId => {
    if (selectedTimeline == null || timelineId !== selectedTimeline.id) {
      queryTimelineById({
        timelineId,
        onOpenTimeline
      });
    }
  }, [onOpenTimeline, queryTimelineById, selectedTimeline]);
  const [urlStateInitialized, setUrlStateInitialized] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!urlStateInitialized) {
      let id = null;
      if (timelineIdFromUrl != null) {
        id = timelineIdFromUrl;
      } else if (timelineIdFromUrlEql != null) {
        id = timelineIdFromUrlEql;
        isEql.current = true;
      }
      if (id != null) {
        setUrlStateInitialized(true);
        getTimelineById(id);
        setLoading(true);
      }
    }
  }, [getTimelineById, timelineIdFromUrl, timelineIdFromUrlEql, urlStateInitialized]);
  // end handle set rule from timeline id

  return {
    loading,
    onOpenTimeline
  };
};
exports.useRuleFromTimeline = useRuleFromTimeline;