"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRIGGERED = exports.TOTAL_COUNT_OF_ALERTS = exports.STATUS = exports.STATS_GROUP_USERS = exports.STATS_GROUP_SEVERITY_UNKNOWN = exports.STATS_GROUP_SEVERITY_MULTI = exports.STATS_GROUP_SEVERITY_MEDIUM = exports.STATS_GROUP_SEVERITY_LOW = exports.STATS_GROUP_SEVERITY_HIGH = exports.STATS_GROUP_SEVERITY_CRITICAL = exports.STATS_GROUP_SEVERITY = exports.STATS_GROUP_RULES = exports.STATS_GROUP_HOSTS = exports.STATS_GROUP_ALERTS = exports.SESSIONS_TITLE = exports.OPEN_ALERTS = exports.OPENED_ALERT_SUCCESS_TOAST = exports.OPENED_ALERT_FAILED_TOAST = exports.MORE_ACTIONS = exports.INVESTIGATE_BULK_IN_TIMELINE = exports.INSUFFICIENT_PRIVILEGES = exports.INSPECT_GROUPING_TITLE = exports.EVENT_RENDERED_VIEW_COLUMNS = exports.CLOSED_ALERT_SUCCESS_TOAST = exports.CLOSED_ALERT_FAILED_TOAST = exports.CLOSED_ALERTS = exports.CLICK_TO_CHANGE_ALERT_STATUS = exports.CHANGE_ALERT_STATUS = exports.ALERT_DURATION = exports.ALERTS_HEADERS_USER_RISK_LEVEL = exports.ALERTS_HEADERS_USER_CRITICALITY = exports.ALERTS_HEADERS_THRESHOLD_TERMS = exports.ALERTS_HEADERS_THRESHOLD_COUNT = exports.ALERTS_HEADERS_THRESHOLD_CARDINALITY = exports.ALERTS_HEADERS_SEVERITY = exports.ALERTS_HEADERS_SERVICE_RISK_LEVEL = exports.ALERTS_HEADERS_SERVICE_CRITICALITY = exports.ALERTS_HEADERS_RULE_NAME = exports.ALERTS_HEADERS_RULE_DESCRIPTION = exports.ALERTS_HEADERS_RULE = exports.ALERTS_HEADERS_RISK_SCORE = exports.ALERTS_HEADERS_REASON = exports.ALERTS_HEADERS_NEW_TERMS_FIELDS = exports.ALERTS_HEADERS_NEW_TERMS = exports.ALERTS_HEADERS_HOST_RISK_LEVEL = exports.ALERTS_HEADERS_HOST_CRITICALITY = exports.ALERTS_HEADERS_ASSIGNEES = exports.ADD_TO_NEW_CASE = exports.ADD_TO_EXISTING_CASE = exports.ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL = exports.ACTION_INVESTIGATE_IN_TIMELINE = exports.ACTION_CANNOT_INVESTIGATE_IN_TIMELINE = exports.ACTION_ADD_EXCEPTION = exports.ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP = exports.ACTION_ADD_EVENT_FILTER = exports.ACTION_ADD_ENDPOINT_EXCEPTION = exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = exports.ACKNOWLEDGED_ALERTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_ALERTS = exports.OPEN_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.openAlertsTitle', {
  defaultMessage: 'Open'
});
const CLOSED_ALERTS = exports.CLOSED_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.closedAlertsTitle', {
  defaultMessage: 'Closed'
});
const ACKNOWLEDGED_ALERTS = exports.ACKNOWLEDGED_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.acknowledgedAlertsTitle', {
  defaultMessage: 'Acknowledged'
});
const TOTAL_COUNT_OF_ALERTS = exports.TOTAL_COUNT_OF_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.totalCountOfAlertsTitle', {
  defaultMessage: 'alerts'
});
const ALERTS_HEADERS_RULE = exports.ALERTS_HEADERS_RULE = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.ruleTitle', {
  defaultMessage: 'Rule'
});
const ALERTS_HEADERS_RULE_NAME = exports.ALERTS_HEADERS_RULE_NAME = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.ruleNameTitle', {
  defaultMessage: 'Rule name'
});
const ALERTS_HEADERS_RULE_DESCRIPTION = exports.ALERTS_HEADERS_RULE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.ruleDescriptionTitle', {
  defaultMessage: 'Rule description'
});
const ALERTS_HEADERS_SEVERITY = exports.ALERTS_HEADERS_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.severityTitle', {
  defaultMessage: 'Severity'
});
const ALERTS_HEADERS_REASON = exports.ALERTS_HEADERS_REASON = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.reasonTitle', {
  defaultMessage: 'Reason'
});
const ALERTS_HEADERS_RISK_SCORE = exports.ALERTS_HEADERS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.riskScoreTitle', {
  defaultMessage: 'Risk Score'
});
const ALERTS_HEADERS_ASSIGNEES = exports.ALERTS_HEADERS_ASSIGNEES = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.assigneesTitle', {
  defaultMessage: 'Assignees'
});
const ALERTS_HEADERS_THRESHOLD_COUNT = exports.ALERTS_HEADERS_THRESHOLD_COUNT = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdCount', {
  defaultMessage: 'Event Count'
});
const ALERTS_HEADERS_THRESHOLD_TERMS = exports.ALERTS_HEADERS_THRESHOLD_TERMS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdTerms', {
  defaultMessage: 'Threshold Terms'
});
const ALERTS_HEADERS_THRESHOLD_CARDINALITY = exports.ALERTS_HEADERS_THRESHOLD_CARDINALITY = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdCardinality', {
  defaultMessage: 'Event Cardinality'
});
const ALERTS_HEADERS_NEW_TERMS = exports.ALERTS_HEADERS_NEW_TERMS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.newTerms', {
  defaultMessage: 'New Terms'
});
const ALERTS_HEADERS_NEW_TERMS_FIELDS = exports.ALERTS_HEADERS_NEW_TERMS_FIELDS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.newTermsFields', {
  defaultMessage: 'New Terms fields'
});
const ALERTS_HEADERS_HOST_RISK_LEVEL = exports.ALERTS_HEADERS_HOST_RISK_LEVEL = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.hostRiskLevel', {
  defaultMessage: 'Host Risk Level'
});
const ALERTS_HEADERS_USER_RISK_LEVEL = exports.ALERTS_HEADERS_USER_RISK_LEVEL = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.userRiskLevel', {
  defaultMessage: 'User Risk Level'
});
const ALERTS_HEADERS_HOST_CRITICALITY = exports.ALERTS_HEADERS_HOST_CRITICALITY = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.hostCriticality', {
  defaultMessage: 'Host Criticality'
});
const ALERTS_HEADERS_SERVICE_RISK_LEVEL = exports.ALERTS_HEADERS_SERVICE_RISK_LEVEL = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.serviceRiskLevel', {
  defaultMessage: 'Service Risk Level'
});
const ALERTS_HEADERS_USER_CRITICALITY = exports.ALERTS_HEADERS_USER_CRITICALITY = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.userCriticality', {
  defaultMessage: 'User Criticality'
});
const ALERTS_HEADERS_SERVICE_CRITICALITY = exports.ALERTS_HEADERS_SERVICE_CRITICALITY = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.serviceCriticality', {
  defaultMessage: 'Service Criticality'
});
const ACTION_INVESTIGATE_IN_TIMELINE = exports.ACTION_INVESTIGATE_IN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.investigateInTimelineTitle', {
  defaultMessage: 'Investigate in timeline'
});
const ACTION_CANNOT_INVESTIGATE_IN_TIMELINE = exports.ACTION_CANNOT_INVESTIGATE_IN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.cannotInvestigateInTimelineTitle', {
  defaultMessage: 'Please navigate to a page with timeline to investigate'
});
const ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL = exports.ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.investigateInTimelineAriaLabel', {
  defaultMessage: 'Send alert to timeline'
});
const ACTION_ADD_EXCEPTION = exports.ACTION_ADD_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addException', {
  defaultMessage: 'Add rule exception'
});
const ACTION_ADD_EVENT_FILTER = exports.ACTION_ADD_EVENT_FILTER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addEventFilter', {
  defaultMessage: 'Add Endpoint event filter'
});
const ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP = exports.ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addEventFilter.disabled.tooltip', {
  defaultMessage: 'Endpoint event filters can be created from the Events section of the Hosts page.'
});
const ACTION_ADD_ENDPOINT_EXCEPTION = exports.ACTION_ADD_ENDPOINT_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addEndpointException', {
  defaultMessage: 'Add Endpoint exception'
});
const CLOSED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.closedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully closed {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.CLOSED_ALERT_SUCCESS_TOAST = CLOSED_ALERT_SUCCESS_TOAST;
const ALERT_DURATION = exports.ALERT_DURATION = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.alertDurationTitle', {
  defaultMessage: 'Alert duration'
});
const OPENED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.openedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully opened {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.OPENED_ALERT_SUCCESS_TOAST = OPENED_ALERT_SUCCESS_TOAST;
const ACKNOWLEDGED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.acknowledgedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully marked {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}} as acknowledged.'
});
exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = ACKNOWLEDGED_ALERT_SUCCESS_TOAST;
const CLOSED_ALERT_FAILED_TOAST = exports.CLOSED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.closedAlertFailedToastMessage', {
  defaultMessage: 'Failed to close alert(s).'
});
const OPENED_ALERT_FAILED_TOAST = exports.OPENED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.openedAlertFailedToastMessage', {
  defaultMessage: 'Failed to open alert(s)'
});
const ACKNOWLEDGED_ALERT_FAILED_TOAST = exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.acknowledgedAlertFailedToastMessage', {
  defaultMessage: 'Failed to mark alert(s) as acknowledged'
});
const MORE_ACTIONS = exports.MORE_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.moreActionsAriaLabel', {
  defaultMessage: 'More actions'
});
const STATUS = exports.STATUS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.statusTitle', {
  defaultMessage: 'Status'
});
const CHANGE_ALERT_STATUS = exports.CHANGE_ALERT_STATUS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.overview.changeAlertStatus', {
  defaultMessage: 'Change alert status'
});
const CLICK_TO_CHANGE_ALERT_STATUS = exports.CLICK_TO_CHANGE_ALERT_STATUS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.overview.clickToChangeAlertStatus', {
  defaultMessage: 'Click to change alert status'
});
const TRIGGERED = exports.TRIGGERED = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.triggeredTitle', {
  defaultMessage: 'Triggered'
});
const ADD_TO_EXISTING_CASE = exports.ADD_TO_EXISTING_CASE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addToCase', {
  defaultMessage: 'Add to existing case'
});
const ADD_TO_NEW_CASE = exports.ADD_TO_NEW_CASE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addToNewCase', {
  defaultMessage: 'Add to new case'
});
const INVESTIGATE_BULK_IN_TIMELINE = exports.INVESTIGATE_BULK_IN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addBulkToTimeline', {
  defaultMessage: 'Investigate in timeline'
});
const SESSIONS_TITLE = exports.SESSIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.sessionsView.sessionsTitle', {
  defaultMessage: 'Sessions'
});
const STATS_GROUP_ALERTS = exports.STATS_GROUP_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.alertsCount', {
  defaultMessage: 'Alerts:'
});
const STATS_GROUP_HOSTS = exports.STATS_GROUP_HOSTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.hostsCount', {
  defaultMessage: 'Hosts:'
});
const STATS_GROUP_USERS = exports.STATS_GROUP_USERS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.usersCount', {
  defaultMessage: 'Users:'
});
const STATS_GROUP_RULES = exports.STATS_GROUP_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.rulesCount', {
  defaultMessage: 'Rules:'
});
const STATS_GROUP_SEVERITY = exports.STATS_GROUP_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity', {
  defaultMessage: 'Severity:'
});
const STATS_GROUP_SEVERITY_MULTI = exports.STATS_GROUP_SEVERITY_MULTI = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.multi', {
  defaultMessage: 'Multi'
});
const STATS_GROUP_SEVERITY_LOW = exports.STATS_GROUP_SEVERITY_LOW = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.low', {
  defaultMessage: 'Low'
});
const STATS_GROUP_SEVERITY_HIGH = exports.STATS_GROUP_SEVERITY_HIGH = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.high', {
  defaultMessage: 'High'
});
const STATS_GROUP_SEVERITY_CRITICAL = exports.STATS_GROUP_SEVERITY_CRITICAL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.critical', {
  defaultMessage: 'Critical'
});
const STATS_GROUP_SEVERITY_MEDIUM = exports.STATS_GROUP_SEVERITY_MEDIUM = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.medium', {
  defaultMessage: 'Medium'
});
const STATS_GROUP_SEVERITY_UNKNOWN = exports.STATS_GROUP_SEVERITY_UNKNOWN = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.unknown', {
  defaultMessage: 'Unknown'
});
const INSPECT_GROUPING_TITLE = exports.INSPECT_GROUPING_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionsEngine.grouping.inspectTitle', {
  defaultMessage: 'Grouping query'
});
const EVENT_RENDERED_VIEW_COLUMNS = exports.EVENT_RENDERED_VIEW_COLUMNS = {
  timestamp: _i18n.i18n.translate('xpack.securitySolution.EventRenderedView.timestampTitle.column', {
    defaultMessage: 'Timestamp'
  }),
  rule: _i18n.i18n.translate('xpack.securitySolution.EventRenderedView.ruleTitle.column', {
    defaultMessage: 'Rule'
  }),
  eventSummary: _i18n.i18n.translate('xpack.securitySolution.EventRenderedView.eventSummary.column', {
    defaultMessage: 'Event Summary'
  })
};
const INSUFFICIENT_PRIVILEGES = exports.INSUFFICIENT_PRIVILEGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.insufficientPrivileges', {
  defaultMessage: 'Insufficient privileges'
});