"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToCaseActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("../../../../../common");
var _cases_tour_steps = require("../../../../common/components/guided_onboarding_tour/cases_tour_steps");
var _tour_config = require("../../../../common/components/guided_onboarding_tour/tour_config");
var _guided_onboarding_tour = require("../../../../common/components/guided_onboarding_tour");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddToCaseActions = ({
  onMenuItemClick,
  ariaLabel,
  ecsData,
  nonEcsData,
  onSuccess,
  isActiveTimelines,
  isInDetections,
  refetch
}) => {
  const {
    cases: casesUi
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = casesUi.helpers.canUseCases([_common2.APP_ID]);
  const isAlert = (0, _react.useMemo)(() => {
    var _ecsData$event, _ecsData$event$kind;
    return ecsData === null || ecsData === void 0 ? void 0 : (_ecsData$event = ecsData.event) === null || _ecsData$event === void 0 ? void 0 : (_ecsData$event$kind = _ecsData$event.kind) === null || _ecsData$event$kind === void 0 ? void 0 : _ecsData$event$kind.includes('signal');
  }, [ecsData]);
  const caseAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_id, _ecsData$_index;
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: (_ecsData$_id = ecsData === null || ecsData === void 0 ? void 0 : ecsData._id) !== null && _ecsData$_id !== void 0 ? _ecsData$_id : '',
      index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
      type: _common.AttachmentType.alert,
      rule: casesUi.helpers.getRuleIdFromEvent({
        ecs: ecsData,
        data: nonEcsData !== null && nonEcsData !== void 0 ? nonEcsData : []
      })
    }] : [];
  }, [casesUi.helpers, ecsData, nonEcsData]);
  const {
    activeStep,
    endTourStep,
    incrementStep,
    isTourShown
  } = (0, _guided_onboarding_tour.useTourContext)();
  const onCaseSuccess = (0, _react.useCallback)(() => {
    if (onSuccess) {
      onSuccess();
    }
    if (refetch) {
      refetch();
    }
  }, [onSuccess, refetch]);
  const afterCaseCreated = (0, _react.useCallback)(async () => {
    if (isTourShown(_tour_config.SecurityStepId.alertsCases)) {
      endTourStep(_tour_config.SecurityStepId.alertsCases);
    }
  }, [endTourStep, isTourShown]);
  const prefillCasesValue = (0, _react.useMemo)(() => isTourShown(_tour_config.SecurityStepId.alertsCases) && (activeStep === _tour_config.AlertsCasesTourSteps.addAlertToCase || activeStep === _tour_config.AlertsCasesTourSteps.createCase || activeStep === _tour_config.AlertsCasesTourSteps.submitCase) ? {
    initialValue: _tour_config.sampleCase
  } : {}, [activeStep, isTourShown]);
  const createCaseArgs = (0, _react.useMemo)(() => {
    return {
      onClose: onMenuItemClick,
      onSuccess: onCaseSuccess,
      afterCaseCreated,
      ...prefillCasesValue
    };
  }, [onMenuItemClick, onCaseSuccess, afterCaseCreated, prefillCasesValue]);
  const createCaseFlyout = casesUi.hooks.useCasesAddToNewCaseFlyout(createCaseArgs);
  const selectCaseArgs = (0, _react.useMemo)(() => {
    return {
      onClose: onMenuItemClick,
      onSuccess: onCaseSuccess
    };
  }, [onMenuItemClick, onCaseSuccess]);
  const selectCaseModal = casesUi.hooks.useCasesAddToExistingCaseModal(selectCaseArgs);
  const handleAddToNewCaseClick = (0, _react.useCallback)(() => {
    // TODO rename this, this is really `closePopover()`
    onMenuItemClick();
    createCaseFlyout.open({
      attachments: caseAttachments,
      // activeStep will be AlertsCasesTourSteps.addAlertToCase on first render because not yet incremented
      // if the user closes the flyout without completing the form and comes back, we will be at step AlertsCasesTourSteps.createCase
      ...(isTourShown(_tour_config.SecurityStepId.alertsCases) ? {
        headerContent: /*#__PURE__*/_react.default.createElement(_cases_tour_steps.CasesTourSteps, null)
      } : {})
    });
    if (isTourShown(_tour_config.SecurityStepId.alertsCases) && activeStep === _tour_config.AlertsCasesTourSteps.addAlertToCase) {
      incrementStep(_tour_config.SecurityStepId.alertsCases);
    }
  }, [onMenuItemClick, createCaseFlyout, caseAttachments, isTourShown, activeStep, incrementStep]);
  const handleAddToExistingCaseClick = (0, _react.useCallback)(() => {
    // TODO rename this, this is really `closePopover()`
    onMenuItemClick();
    selectCaseModal.open({
      getAttachments: () => caseAttachments
    });
  }, [caseAttachments, onMenuItemClick, selectCaseModal]);
  const addToCaseActionItems = (0, _react.useMemo)(() => {
    if ((isActiveTimelines || isInDetections) && userCasesPermissions.createComment && userCasesPermissions.read && isAlert) {
      return [
      // add to existing case menu item
      {
        'aria-label': ariaLabel,
        'data-test-subj': 'add-to-existing-case-action',
        key: 'add-to-existing-case-action',
        onClick: handleAddToExistingCaseClick,
        size: 's',
        name: _translations.ADD_TO_EXISTING_CASE
      },
      // add to new case menu item
      {
        'aria-label': ariaLabel,
        'data-test-subj': 'add-to-new-case-action',
        key: 'add-to-new-case-action',
        onClick: handleAddToNewCaseClick,
        size: 's',
        name: _translations.ADD_TO_NEW_CASE
      }];
    }
    return [];
  }, [isActiveTimelines, isInDetections, userCasesPermissions.createComment, userCasesPermissions.read, isAlert, ariaLabel, handleAddToExistingCaseClick, handleAddToNewCaseClick]);
  return {
    addToCaseActionItems,
    handleAddToNewCaseClick,
    handleAddToExistingCaseClick
  };
};
exports.useAddToCaseActions = useAddToCaseActions;