"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsInvestigateInResolverActionEnabled = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsInvestigateInResolverActionEnabled = ecsData => {
  const sentinelOneDataInAnalyzerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneDataInAnalyzerEnabled');
  const crowdstrikeDataInAnalyzerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('crowdstrikeDataInAnalyzerEnabled');
  const jamfDataInAnalyzerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('jamfDataInAnalyzerEnabled');
  return (0, _react.useMemo)(() => {
    const fileBeatModules = [...(sentinelOneDataInAnalyzerEnabled ? ['sentinel_one_cloud_funnel', 'sentinel_one'] : []), ...(crowdstrikeDataInAnalyzerEnabled ? ['crowdstrike'] : []), ...(jamfDataInAnalyzerEnabled ? ['jamf_protect'] : [])];
    const agentType = (0, _fp.get)(['agent', 'type', 0], ecsData);
    const processEntityIds = (0, _fp.get)(['process', 'entity_id'], ecsData);
    const firstProcessEntityId = (0, _fp.get)(['process', 'entity_id', 0], ecsData);
    const eventModule = (0, _fp.get)(['event', 'module', 0], ecsData);
    const eventDataStream = (0, _fp.get)(['event', 'dataset'], ecsData);
    const datasetIncludesSysmon = Array.isArray(eventDataStream) && eventDataStream.some(datastream => datastream.includes('windows.sysmon'));
    const agentTypeIsEndpoint = agentType === 'endpoint';
    const agentTypeIsWinlogBeat = agentType === 'winlogbeat' && eventModule === 'sysmon';
    const agentTypeIsFilebeat = agentType === 'filebeat' && fileBeatModules.includes(eventModule);
    const isAcceptedAgentType = agentTypeIsEndpoint || agentTypeIsWinlogBeat || datasetIncludesSysmon || agentTypeIsFilebeat;
    const hasProcessEntityId = processEntityIds != null && processEntityIds.length === 1 && firstProcessEntityId !== '';
    return isAcceptedAgentType && hasProcessEntityId;
  }, [crowdstrikeDataInAnalyzerEnabled, ecsData, sentinelOneDataInAnalyzerEnabled, jamfDataInAnalyzerEnabled]);
};
exports.useIsInvestigateInResolverActionEnabled = useIsInvestigateInResolverActionEnabled;